/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.List;
import java.util.Set;

public class ChangeAttributeNames2Generic
extends AbstractDataProcessing {
    public static final String PARAMETER_NAME_STEM = "generic_name_stem";
    private final AttributeSubsetSelector attributeSelector = new AttributeSubsetSelector(this, this.getExampleSetInputPort());

    public ChangeAttributeNames2Generic(OperatorDescription description) {
        super(description);
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData exampleSetMetaData) {
        try {
            ExampleSetMetaData subsetMetaData = this.attributeSelector.getMetaDataSubset(exampleSetMetaData, false);
            String nameStem = this.isParameterSet(PARAMETER_NAME_STEM) ? this.getParameterAsString(PARAMETER_NAME_STEM) : "";
            int counter = 1;
            for (AttributeMetaData attributeMetaData : subsetMetaData.getAllAttributes()) {
                String name = attributeMetaData.getName();
                exampleSetMetaData.getAttributeByName(name).setName(nameStem + counter++);
            }
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        return exampleSetMetaData;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        Set<Attribute> attributeSubset = this.attributeSelector.getAttributeSubset(exampleSet, false);
        String nameStem = this.isParameterSet(PARAMETER_NAME_STEM) ? this.getParameterAsString(PARAMETER_NAME_STEM) : "";
        int counter = 1;
        for (Attribute attribute : attributeSubset) {
            attribute.setName(nameStem + counter++);
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.addAll(this.attributeSelector.getParameterTypes());
        ParameterTypeString type = new ParameterTypeString(PARAMETER_NAME_STEM, "Specifies the name stem which is used to build generic names. Using 'att' as stem would lead to 'att1', 'att2', etc. as attribute names.", "att");
        type.setExpert(false);
        types.add(type);
        return types;
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), ChangeAttributeNames2Generic.class, this.attributeSelector);
    }
}

