/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.AttributeSetPrecondition;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.MetaDataInfo;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.List;

public class ChangeAttributeName
extends AbstractDataProcessing {
    public static final String PARAMETER_OLD_NAME = "old_name";
    public static final String PARAMETER_NEW_NAME = "new_name";
    public static final String PARAMETER_RENAME_ATTRIBUTES = "rename_additional_attributes";

    public ChangeAttributeName(OperatorDescription description) {
        super(description);
        this.getExampleSetInputPort().addPrecondition(new AttributeSetPrecondition(this.getExampleSetInputPort(), AttributeSetPrecondition.getAttributesByParameter(this, PARAMETER_OLD_NAME), new String[0]));
        this.getExampleSetInputPort().addPrecondition(new AttributeSetPrecondition(this.getExampleSetInputPort(), AttributeSetPrecondition.getAttributesByParameterListEntry(this, PARAMETER_RENAME_ATTRIBUTES, 0), new String[0]));
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData metaData) {
        try {
            String newName = null;
            if (this.isParameterSet(PARAMETER_NEW_NAME)) {
                newName = this.getParameterAsString(PARAMETER_NEW_NAME);
            }
            if (this.isParameterSet(PARAMETER_OLD_NAME)) {
                String oldName = this.getParameter(PARAMETER_OLD_NAME);
                this.renameAttributeMetaData(metaData, oldName, newName);
            }
            if (this.isParameterSet(PARAMETER_RENAME_ATTRIBUTES)) {
                List<String[]> renamings = this.getParameterList(PARAMETER_RENAME_ATTRIBUTES);
                for (String[] pair : renamings) {
                    this.renameAttributeMetaData(metaData, pair[0], pair[1]);
                }
            }
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        return metaData;
    }

    private void renameAttributeMetaData(ExampleSetMetaData metaData, String oldName, String newName) throws UndefinedParameterError {
        AttributeMetaData amd = metaData.getAttributeByName(oldName);
        if (amd != null && newName != null) {
            if (metaData.containsAttributeName(newName) == MetaDataInfo.YES) {
                this.getInputPort().addError(new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)this.getInputPort(), "already_contains_attribute", newName));
            } else {
                amd.setName(newName);
            }
        }
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        String oldName = this.getParameterAsString(PARAMETER_OLD_NAME);
        String newName = this.getParameterAsString(PARAMETER_NEW_NAME);
        this.renameAttribute(exampleSet, oldName, newName);
        if (this.isParameterSet(PARAMETER_RENAME_ATTRIBUTES)) {
            List<String[]> renamings = this.getParameterList(PARAMETER_RENAME_ATTRIBUTES);
            for (String[] pair : renamings) {
                this.renameAttribute(exampleSet, pair[0], pair[1]);
            }
        }
        return exampleSet;
    }

    private void renameAttribute(ExampleSet exampleSet, String oldName, String newName) throws UserError {
        Attribute attribute = exampleSet.getAttributes().get(oldName);
        if (attribute == null) {
            throw new UserError((Operator)this, 111, oldName);
        }
        attribute.setName(newName);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeAttribute(PARAMETER_OLD_NAME, "The old name of the attribute.", this.getExampleSetInputPort(), false));
        types.add(new ParameterTypeString(PARAMETER_NEW_NAME, "The new name of the attribute.", false));
        types.add(new ParameterTypeList(PARAMETER_RENAME_ATTRIBUTES, "A list that can be used to define additional attributes that should be renamed.", (ParameterType)new ParameterTypeAttribute(PARAMETER_OLD_NAME, "The old name of the attribute.", this.getExampleSetInputPort(), false), (ParameterType)new ParameterTypeString(PARAMETER_NEW_NAME, "The new name of the attribute.", false), false));
        return types;
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), ChangeAttributeName.class, null);
    }
}

