/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.preprocessing.AbstractValueProcessing;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;

public class AttributeValueTrim
extends AbstractValueProcessing {
    public AttributeValueTrim(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet applyOnFiltered(ExampleSet exampleSet) throws OperatorException {
        LinkedHashMap<Attribute, Attribute> attributeMap = new LinkedHashMap<Attribute, Attribute>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            Attribute newAttribute = AttributeFactory.createAttribute(attribute.getValueType());
            attributeMap.put(attribute, newAttribute);
            for (String value : attribute.getMapping().getValues()) {
                String trimmedValue = value.trim();
                if (trimmedValue.length() <= 0) continue;
                newAttribute.getMapping().mapString(trimmedValue);
            }
        }
        for (Map.Entry entry : attributeMap.entrySet()) {
            Attribute oldAttribute = (Attribute)entry.getKey();
            Attribute newAttribute = (Attribute)entry.getValue();
            exampleSet.getExampleTable().addAttribute(newAttribute);
            exampleSet.getAttributes().addRegular(newAttribute);
            for (Example example : exampleSet) {
                double value = example.getValue(oldAttribute);
                if (Double.isNaN(value)) {
                    example.setValue(newAttribute, Double.NaN);
                    continue;
                }
                String trimmedValue = oldAttribute.getMapping().mapIndex((int)value).trim();
                if (trimmedValue.length() == 0) {
                    example.setValue(newAttribute, Double.NaN);
                    continue;
                }
                example.setValue(newAttribute, newAttribute.getMapping().mapString(trimmedValue));
            }
            exampleSet.getAttributes().remove(oldAttribute);
            newAttribute.setName(oldAttribute.getName());
        }
        return exampleSet;
    }

    @Override
    public ExampleSetMetaData applyOnFilteredMetaData(ExampleSetMetaData emd) {
        for (AttributeMetaData amd : emd.getAllAttributes()) {
            TreeSet<String> valueSet = new TreeSet<String>();
            for (String value : amd.getValueSet()) {
                String trimmedValue = value.trim();
                if (trimmedValue.length() <= 0) continue;
                valueSet.add(trimmedValue);
            }
            amd.setValueSet(valueSet, SetRelation.SUBSET);
        }
        return emd;
    }

    @Override
    protected int[] getFilterValueTypes() {
        return new int[]{1};
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), AttributeValueTrim.class, null);
    }
}

