/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.preprocessing.AbstractValueProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class AttributeValueSubstring
extends AbstractValueProcessing {
    public static final String PARAMETER_FIRST = "first_character_index";
    public static final String PARAMETER_LAST = "last_character_index";

    public AttributeValueSubstring(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet applyOnFiltered(ExampleSet exampleSet) throws OperatorException {
        int firstIndex = this.getParameterAsInt(PARAMETER_FIRST);
        int lastIndex = this.getParameterAsInt(PARAMETER_LAST);
        LinkedHashMap<Attribute, Attribute> attributeMap = new LinkedHashMap<Attribute, Attribute>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            Attribute newAttribute = AttributeFactory.createAttribute(attribute.getValueType());
            attributeMap.put(attribute, newAttribute);
            for (String value : attribute.getMapping().getValues()) {
                int actualLast;
                int actualFirst;
                String substringValue = value.substring(actualFirst = firstIndex - 1, actualLast = lastIndex <= value.length() ? lastIndex : value.length());
                if (substringValue.length() <= 0) continue;
                newAttribute.getMapping().mapString(substringValue);
            }
        }
        for (Map.Entry entry : attributeMap.entrySet()) {
            Attribute oldAttribute = (Attribute)entry.getKey();
            Attribute newAttribute = (Attribute)entry.getValue();
            exampleSet.getExampleTable().addAttribute(newAttribute);
            exampleSet.getAttributes().addRegular(newAttribute);
            for (Example example : exampleSet) {
                int actualLast;
                double value = example.getValue(oldAttribute);
                if (Double.isNaN(value)) {
                    example.setValue(newAttribute, Double.NaN);
                    continue;
                }
                String stringValue = oldAttribute.getMapping().mapIndex((int)value);
                int actualFirst = firstIndex - 1;
                int n = actualLast = lastIndex <= stringValue.length() ? lastIndex : stringValue.length();
                if (lastIndex < firstIndex) {
                    example.setValue(newAttribute, Double.NaN);
                    continue;
                }
                String substringValue = stringValue.substring(actualFirst, actualLast);
                if (substringValue.length() == 0) {
                    example.setValue(newAttribute, Double.NaN);
                    continue;
                }
                example.setValue(newAttribute, substringValue);
            }
            exampleSet.getAttributes().remove(oldAttribute);
            newAttribute.setName(oldAttribute.getName());
        }
        return exampleSet;
    }

    @Override
    public ExampleSetMetaData applyOnFilteredMetaData(ExampleSetMetaData emd) throws UndefinedParameterError {
        int firstIndex = this.getParameterAsInt(PARAMETER_FIRST);
        int lastIndex = this.getParameterAsInt(PARAMETER_LAST);
        for (AttributeMetaData amd : emd.getAllAttributes()) {
            TreeSet<String> valueSet = new TreeSet<String>();
            for (String value : amd.getValueSet()) {
                int actualLast;
                int actualFirst;
                String substringValue = value.substring(actualFirst = firstIndex - 1, actualLast = lastIndex <= value.length() ? lastIndex : value.length());
                if (substringValue.length() <= 0) continue;
                valueSet.add(substringValue);
            }
            amd.setValueSet(valueSet, SetRelation.SUBSET);
        }
        return emd;
    }

    @Override
    protected int[] getFilterValueTypes() {
        return new int[]{1};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_FIRST, "The index of the first character of the substring which should be kept (counting starts with 1, 0: start with beginning of value).", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_LAST, "The index of the last character of the substring which should be kept (counting starts with 1, 0: end with end of value).", 1, Integer.MAX_VALUE, Integer.MAX_VALUE);
        type.setExpert(false);
        types.add(type);
        return types;
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), AttributeValueSubstring.class, null);
    }
}

