/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeRegexp;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class AttributeValueSplit
extends AbstractDataProcessing {
    public static final String PARAMETER_SPLIT_PATTERN = "split_pattern";
    public static final String PARAMETER_SPLIT_MODE = "split_mode";
    public static final String[] SPLIT_MODES = new String[]{"ordered_split", "unordered_split"};
    public static final int SPLIT_MODE_ORDERED = 0;
    public static final int SPLIT_MODE_UNORDERED = 1;
    private AttributeSubsetSelector attributeSubsetSelector = new AttributeSubsetSelector(this, this.getExampleSetInputPort(), 1);

    public AttributeValueSplit(OperatorDescription description) {
        super(description);
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData metaData) throws UndefinedParameterError {
        String splittingRegex = this.getParameterAsString(PARAMETER_SPLIT_PATTERN);
        try {
            Pattern splittingPattern = Pattern.compile(splittingRegex);
            ExampleSetMetaData subset = this.attributeSubsetSelector.getMetaDataSubset(metaData, false);
            SetRelation attributeSetRelation = SetRelation.EQUAL;
            for (AttributeMetaData amd : subset.getAllAttributes()) {
                if (amd.isSpecial() || !amd.isNominal()) continue;
                attributeSetRelation = attributeSetRelation.merge(amd.getValueSetRelation());
                int maxNumber = 0;
                if (amd.getValueSetRelation() == SetRelation.SUBSET || amd.getValueSetRelation() == SetRelation.UNKNOWN) {
                    maxNumber = 3;
                }
                String[][] valueParts = new String[amd.getValueSet().size()][];
                int i = 0;
                for (String value : amd.getValueSet()) {
                    valueParts[i] = splittingPattern.split(value);
                    maxNumber = Math.max(maxNumber, valueParts[i].length);
                    ++i;
                }
                metaData.removeAttribute(metaData.getAttributeByName(amd.getName()));
                for (i = 0; i < maxNumber; ++i) {
                    AttributeMetaData newAmd = new AttributeMetaData(amd.getName() + "_" + (i + 1), 1);
                    HashSet<String> valueSet = new HashSet<String>();
                    for (int value = 0; value < valueParts.length; ++value) {
                        if (valueParts[value].length <= i) continue;
                        valueSet.add(valueParts[value][i]);
                    }
                    newAmd.setValueSet(valueSet, amd.getValueSetRelation());
                    if (i > 0) {
                        newAmd.getNumberOfMissingValues().increaseByUnknownAmount();
                    }
                    metaData.addAttribute(newAmd);
                }
            }
            metaData.mergeSetRelation(attributeSetRelation);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return metaData;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        String splittingRegex = this.getParameterAsString(PARAMETER_SPLIT_PATTERN);
        Pattern splittingPattern = null;
        try {
            splittingPattern = Pattern.compile(splittingRegex);
        }
        catch (PatternSyntaxException e) {
            throw new UserError((Operator)this, 206, splittingRegex, e.getMessage());
        }
        int type = this.getParameterAsInt(PARAMETER_SPLIT_MODE);
        block5: for (Attribute attribute : this.attributeSubsetSelector.getAttributeSubset(exampleSet, false)) {
            if (!attribute.isNominal()) continue;
            switch (type) {
                case 0: {
                    this.orderedSplit(exampleSet, attribute, splittingPattern);
                    continue block5;
                }
            }
            this.unorderedSplit(exampleSet, attribute, splittingPattern);
        }
        return exampleSet;
    }

    private void orderedSplit(ExampleSet exampleSet, Attribute attribute, Pattern splittingPattern) {
        int maxNumber = 0;
        for (Example example : exampleSet) {
            String value = example.getNominalValue(attribute);
            String[] parts = splittingPattern.split(value);
            maxNumber = Math.max(maxNumber, parts.length);
        }
        if (maxNumber >= 2) {
            Attribute[] newAttributes = new Attribute[maxNumber];
            for (int a = 0; a < maxNumber; ++a) {
                newAttributes[a] = AttributeFactory.createAttribute(attribute.getName() + "_" + (a + 1), 1);
                exampleSet.getExampleTable().addAttribute(newAttributes[a]);
                exampleSet.getAttributes().addRegular(newAttributes[a]);
            }
            for (Example example : exampleSet) {
                String value = example.getNominalValue(attribute);
                String[] parts = splittingPattern.split(value);
                int p = 0;
                for (String part : parts) {
                    example.setValue(newAttributes[p], newAttributes[p].getMapping().mapString(part));
                    ++p;
                }
                while (p < maxNumber) {
                    example.setValue(newAttributes[p], Double.NaN);
                    ++p;
                }
            }
            exampleSet.getAttributes().remove(attribute);
        }
    }

    private void unorderedSplit(ExampleSet exampleSet, Attribute attribute, Pattern splittingPattern) {
        TreeSet<String> allValues = new TreeSet<String>();
        boolean splitFound = false;
        for (Example example : exampleSet) {
            String[] parts;
            String value = example.getNominalValue(attribute);
            for (String part : parts = splittingPattern.split(value)) {
                allValues.add(part);
            }
            if (parts.length <= 1) continue;
            splitFound = true;
        }
        if (splitFound) {
            Attribute[] newAttributes = new Attribute[allValues.size()];
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            int a = 0;
            for (String value : allValues) {
                newAttributes[a] = AttributeFactory.createAttribute(attribute.getName() + "_" + value, 6);
                newAttributes[a].getMapping().mapString("false");
                newAttributes[a].getMapping().mapString("true");
                exampleSet.getExampleTable().addAttribute(newAttributes[a]);
                exampleSet.getAttributes().addRegular(newAttributes[a]);
                indexMap.put(value, a);
                ++a;
            }
            for (Example example : exampleSet) {
                for (Attribute newAttribute : newAttributes) {
                    example.setValue(newAttribute, newAttribute.getMapping().mapString("false"));
                }
                String value = example.getNominalValue(attribute);
                String[] parts = splittingPattern.split(value);
                int p = 0;
                for (String part : parts) {
                    Attribute newAttribute = newAttributes[(Integer)indexMap.get(part)];
                    example.setValue(newAttribute, newAttribute.getMapping().mapString("true"));
                    ++p;
                }
            }
            exampleSet.getAttributes().remove(attribute);
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.addAll(this.attributeSubsetSelector.getParameterTypes());
        ParameterTypeSingle type = new ParameterTypeRegexp(PARAMETER_SPLIT_PATTERN, "The pattern which is used for dividing the nominal values into different parts.", ",");
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_SPLIT_MODE, "The split mode of this operator, either ordered splits (keeping the original order) or unordered (keeping basket-like information).", SPLIT_MODES, 0);
        type.setExpert(false);
        types.add(type);
        return types;
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), AttributeValueSplit.class, this.attributeSubsetSelector);
    }
}

