/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.preprocessing.AbstractValueProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeRegexp;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AttributeValueReplace
extends AbstractValueProcessing {
    public static final String PARAMETER_REPLACE_WHAT = "replace_what";
    public static final String PARAMETER_REPLACE_BY = "replace_by";

    public AttributeValueReplace(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSetMetaData applyOnFilteredMetaData(ExampleSetMetaData emd) throws UndefinedParameterError {
        String replaceWhat = this.getParameterAsString(PARAMETER_REPLACE_WHAT);
        Pattern whatPattern = Pattern.compile(replaceWhat);
        String replaceBy = "";
        if (this.isParameterSet(PARAMETER_REPLACE_BY)) {
            replaceBy = this.getParameterAsString(PARAMETER_REPLACE_BY);
        }
        for (AttributeMetaData amd : emd.getAllAttributes()) {
            TreeSet<String> valueSet = new TreeSet<String>();
            for (String value : amd.getValueSet()) {
                Matcher whatMatcher = whatPattern.matcher(value);
                String replacedValue = whatMatcher.replaceAll(replaceBy);
                if (replacedValue.length() <= 0) continue;
                valueSet.add(replacedValue);
            }
            amd.setValueSet(valueSet, SetRelation.SUBSET);
        }
        return emd;
    }

    @Override
    public ExampleSet applyOnFiltered(ExampleSet exampleSet) throws OperatorException {
        String replaceWhat = this.getParameterAsString(PARAMETER_REPLACE_WHAT);
        Pattern whatPattern = Pattern.compile(replaceWhat);
        String replaceBy = "";
        if (this.isParameterSet(PARAMETER_REPLACE_BY)) {
            replaceBy = this.getParameterAsString(PARAMETER_REPLACE_BY);
        }
        LinkedHashMap<Attribute, Attribute> attributeMap = new LinkedHashMap<Attribute, Attribute>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            Attribute newAttribute = AttributeFactory.createAttribute(attribute.getValueType());
            attributeMap.put(attribute, newAttribute);
            for (String value : attribute.getMapping().getValues()) {
                Matcher whatMatcher = whatPattern.matcher(value);
                String replacedValue = whatMatcher.replaceAll(replaceBy);
                if (replacedValue.length() <= 0) continue;
                newAttribute.getMapping().mapString(replacedValue);
            }
        }
        for (Map.Entry entry : attributeMap.entrySet()) {
            Attribute oldAttribute = (Attribute)entry.getKey();
            Attribute newAttribute = (Attribute)entry.getValue();
            exampleSet.getExampleTable().addAttribute(newAttribute);
            exampleSet.getAttributes().addRegular(newAttribute);
            for (Example example : exampleSet) {
                double value = example.getValue(oldAttribute);
                if (Double.isNaN(value)) {
                    example.setValue(newAttribute, Double.NaN);
                    continue;
                }
                String stringValue = oldAttribute.getMapping().mapIndex((int)value);
                Matcher whatMatcher = whatPattern.matcher(stringValue);
                String newValue = whatMatcher.replaceAll(replaceBy);
                if (newValue.length() == 0) {
                    example.setValue(newAttribute, Double.NaN);
                    continue;
                }
                example.setValue(newAttribute, newAttribute.getMapping().mapString(newValue));
            }
            exampleSet.getAttributes().remove(oldAttribute);
            newAttribute.setName(oldAttribute.getName());
            newAttribute.setConstruction("replace(" + oldAttribute.getName() + "," + replaceWhat + "," + replaceBy + ")");
        }
        return exampleSet;
    }

    @Override
    protected int[] getFilterValueTypes() {
        return new int[]{1};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeRegexp(PARAMETER_REPLACE_WHAT, "A regular expression specifying what should be replaced.", false, false));
        types.add(new ParameterTypeString(PARAMETER_REPLACE_BY, "The replacement for the region matched by the regular expression. Possibly including capturing groups.", true, false));
        return types;
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), AttributeValueReplace.class, null);
    }
}

