/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.preprocessing.AbstractValueProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import com.rapidminer.tools.math.container.Range;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class AttributeValueMapper
extends AbstractValueProcessing {
    public static final String PARAMETER_NEW_VALUES = "new_value";
    public static final String PARAMETER_VALUE_MAPPINGS = "value_mappings";
    public static final String PARAMETER_OLD_VALUES = "old_values";
    public static final String PARAMETER_REPLACE_WHAT = "replace_what";
    public static final String PARAMETER_REPLACE_BY = "replace_by";
    public static final String PARAMETER_CONSIDER_REGULAR_EXPRESSIONS = "consider_regular_expressions";
    public static final String PARAMETER_ADD_DEFAULT_MAPPING = "add_default_mapping";
    public static final String PARAMETER_DEFAULT_VALUE = "default_value";

    public AttributeValueMapper(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSetMetaData applyOnFilteredMetaData(ExampleSetMetaData emd) {
        block33: {
            try {
                if (emd.getAllAttributes().isEmpty()) {
                    return emd;
                }
                boolean first = true;
                boolean nominal = false;
                for (AttributeMetaData amd : emd.getAllAttributes()) {
                    if (first) {
                        nominal = amd.isNominal();
                        first = false;
                        continue;
                    }
                    if (nominal == amd.isNominal()) continue;
                    this.addError(new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), "attributes_must_have_same_type", new Object[0]));
                    return emd;
                }
                boolean useValueRegex = this.getParameterAsBoolean(PARAMETER_CONSIDER_REGULAR_EXPRESSIONS);
                List<String[]> mappingParameterList = this.getParameterList(PARAMETER_VALUE_MAPPINGS);
                String replaceWhat = this.getParameterAsString(PARAMETER_REPLACE_WHAT);
                String replaceBy = this.getParameterAsString(PARAMETER_REPLACE_BY);
                LinkedHashMap<String, String> mappings = new LinkedHashMap<String, String>();
                LinkedHashMap<Pattern, String> patternMappings = new LinkedHashMap<Pattern, String>();
                if (replaceWhat != null && replaceBy != null && !replaceWhat.equals("") && !replaceBy.equals("")) {
                    mappings.put(replaceWhat, replaceBy);
                    if (useValueRegex) {
                        try {
                            Pattern valuePattern = Pattern.compile(replaceWhat);
                            patternMappings.put(valuePattern, replaceBy);
                        }
                        catch (PatternSyntaxException e) {
                            // empty catch block
                        }
                    }
                }
                Iterator<String[]> listIterator = mappingParameterList.iterator();
                int j = 0;
                while (listIterator.hasNext()) {
                    String[] pair = listIterator.next();
                    replaceWhat = pair[0];
                    replaceBy = pair[1];
                    mappings.put(replaceWhat, replaceBy);
                    if (useValueRegex) {
                        try {
                            Pattern valuePattern = Pattern.compile(replaceWhat);
                            patternMappings.put(valuePattern, replaceBy);
                        }
                        catch (PatternSyntaxException e) {
                            // empty catch block
                        }
                    }
                    ++j;
                }
                boolean defaultMappingAdded = this.getParameterAsBoolean(PARAMETER_ADD_DEFAULT_MAPPING);
                String defaultValue = this.getParameterAsString(PARAMETER_DEFAULT_VALUE);
                if (nominal) {
                    for (AttributeMetaData amd : emd.getAllAttributes()) {
                        TreeSet<String> valueSet = new TreeSet<String>();
                        for (String value : amd.getValueSet()) {
                            String mappedValue = (String)((HashMap)mappings).get(value);
                            if (useValueRegex) {
                                for (Map.Entry patternEntry : ((HashMap)patternMappings).entrySet()) {
                                    Matcher matcher = ((Pattern)patternEntry.getKey()).matcher(value);
                                    if (!matcher.matches()) continue;
                                    mappedValue = (String)patternEntry.getValue();
                                    break;
                                }
                            }
                            if (mappedValue == null) {
                                if (defaultMappingAdded) {
                                    if (defaultValue.equals("?")) continue;
                                    valueSet.add(defaultValue);
                                    continue;
                                }
                                valueSet.add(value);
                                continue;
                            }
                            valueSet.add(mappedValue);
                        }
                        amd.setValueSet(valueSet, SetRelation.SUBSET);
                    }
                    break block33;
                }
                HashMap<Double, Double> numericalValueMapping = new HashMap<Double, Double>();
                for (Map.Entry entry : ((HashMap)mappings).entrySet()) {
                    double oldValue = Double.NaN;
                    double newValue = Double.NaN;
                    if (!((String)entry.getKey()).equals("?")) {
                        try {
                            oldValue = Double.valueOf((String)entry.getKey());
                        }
                        catch (NumberFormatException e) {
                            this.addError(new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), "mapping_must_be_number", entry.getKey()));
                            continue;
                        }
                    }
                    if (!((String)entry.getValue()).equals("?")) {
                        try {
                            newValue = Double.valueOf((String)entry.getValue());
                        }
                        catch (NumberFormatException e) {
                            this.addError(new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), "mapping_must_be_number", entry.getValue()));
                            continue;
                        }
                    }
                    numericalValueMapping.put(oldValue, newValue);
                }
                double numericalDefaultValue = Double.NaN;
                if (defaultMappingAdded && !defaultValue.equals("?")) {
                    numericalDefaultValue = Double.valueOf(defaultValue);
                }
                for (AttributeMetaData amd : emd.getAllAttributes()) {
                    double lower = amd.getValueRange().getLower();
                    double upper = amd.getValueRange().getUpper();
                    double mappedLower = Double.POSITIVE_INFINITY;
                    double mappedUpper = Double.NEGATIVE_INFINITY;
                    for (Double value : numericalValueMapping.values()) {
                        if (value < mappedLower) {
                            mappedLower = value;
                        }
                        if (!(value > mappedUpper)) continue;
                        mappedUpper = value;
                    }
                    if (!Double.isNaN(numericalDefaultValue) && numericalDefaultValue < mappedLower) {
                        mappedLower = numericalDefaultValue;
                    }
                    if (!Double.isNaN(numericalDefaultValue) && numericalDefaultValue > mappedUpper) {
                        mappedUpper = numericalDefaultValue;
                    }
                    amd.setValueRange(new Range(Math.min(lower, mappedLower), Math.max(upper, mappedUpper)), SetRelation.SUBSET);
                }
            }
            catch (UndefinedParameterError undefinedParameterError) {
                // empty catch block
            }
        }
        return emd;
    }

    @Override
    public ExampleSet applyOnFiltered(ExampleSet exampleSet) throws OperatorException {
        block39: {
            boolean first = true;
            boolean nominal = false;
            LinkedHashMap<Attribute, Attribute> attributeMap = new LinkedHashMap<Attribute, Attribute>();
            for (Attribute oldAttribute : exampleSet.getAttributes()) {
                if (first) {
                    nominal = oldAttribute.isNominal();
                    first = false;
                } else if (nominal != oldAttribute.isNominal()) {
                    throw new UserError((Operator)this, 126);
                }
                Attribute newAttribute = AttributeFactory.createAttribute(oldAttribute.getValueType());
                attributeMap.put(oldAttribute, newAttribute);
            }
            boolean useValueRegex = this.getParameterAsBoolean(PARAMETER_CONSIDER_REGULAR_EXPRESSIONS);
            List<String[]> mappingParameterList = this.getParameterList(PARAMETER_VALUE_MAPPINGS);
            String replaceWhat = this.getParameterAsString(PARAMETER_REPLACE_WHAT);
            String replaceBy = this.getParameterAsString(PARAMETER_REPLACE_BY);
            LinkedHashMap<String, String> mappings = new LinkedHashMap<String, String>();
            LinkedHashMap<Pattern, String> patternMappings = new LinkedHashMap<Pattern, String>();
            if (replaceWhat != null && replaceBy != null && !replaceWhat.equals("") && !replaceBy.equals("")) {
                mappings.put(replaceWhat, replaceBy);
                if (useValueRegex) {
                    try {
                        Pattern valuePattern = Pattern.compile(replaceWhat);
                        patternMappings.put(valuePattern, replaceBy);
                    }
                    catch (PatternSyntaxException e) {
                        throw new UserError((Operator)this, 206, replaceWhat, e.getMessage());
                    }
                }
            }
            Iterator<String[]> listIterator = mappingParameterList.iterator();
            int j = 0;
            while (listIterator.hasNext()) {
                String[] pair = listIterator.next();
                replaceWhat = pair[0];
                replaceBy = pair[1];
                mappings.put(replaceWhat, replaceBy);
                if (useValueRegex) {
                    try {
                        Pattern valuePattern = Pattern.compile(replaceWhat);
                        patternMappings.put(valuePattern, replaceBy);
                    }
                    catch (PatternSyntaxException e) {
                        throw new UserError((Operator)this, 206, replaceWhat, e.getMessage());
                    }
                }
                ++j;
            }
            boolean defaultMappingAdded = this.getParameterAsBoolean(PARAMETER_ADD_DEFAULT_MAPPING);
            String defaultValue = this.getParameterAsString(PARAMETER_DEFAULT_VALUE);
            if (defaultMappingAdded && (defaultValue == null || defaultValue.equals(""))) {
                throw new UserError((Operator)this, 201, PARAMETER_ADD_DEFAULT_MAPPING, "true", PARAMETER_DEFAULT_VALUE);
            }
            if (attributeMap.size() <= 0) break block39;
            if (nominal) {
                for (Map.Entry entry : attributeMap.entrySet()) {
                    Attribute oldAttribute = (Attribute)entry.getKey();
                    Attribute newAttribute = (Attribute)entry.getValue();
                    exampleSet.getExampleTable().addAttribute(newAttribute);
                    exampleSet.getAttributes().addRegular(newAttribute);
                    for (Example example : exampleSet) {
                        double value = example.getValue(oldAttribute);
                        String stringValue = null;
                        stringValue = Double.isNaN(value) ? "?" : oldAttribute.getMapping().mapIndex((int)value);
                        String mappedValue = (String)((HashMap)mappings).get(stringValue);
                        if (useValueRegex) {
                            for (Map.Entry patternEntry : ((HashMap)patternMappings).entrySet()) {
                                Matcher matcher = ((Pattern)patternEntry.getKey()).matcher(stringValue);
                                if (!matcher.matches()) continue;
                                mappedValue = (String)patternEntry.getValue();
                                break;
                            }
                        }
                        if (mappedValue == null) {
                            if (stringValue.equals("?")) {
                                example.setValue(newAttribute, Double.NaN);
                            } else if (defaultMappingAdded) {
                                if (defaultValue.equals("?")) {
                                    example.setValue(newAttribute, Double.NaN);
                                } else {
                                    example.setValue(newAttribute, defaultValue);
                                }
                            } else {
                                example.setValue(newAttribute, newAttribute.getMapping().mapString(stringValue));
                            }
                        } else if (mappedValue.equals("?")) {
                            example.setValue(newAttribute, Double.NaN);
                        } else {
                            example.setValue(newAttribute, newAttribute.getMapping().mapString(mappedValue));
                        }
                        this.checkForStop();
                    }
                    exampleSet.getAttributes().remove(oldAttribute);
                    newAttribute.setName(oldAttribute.getName());
                }
            } else {
                HashMap<Double, Double> numericalValueMapping = new HashMap<Double, Double>();
                for (Map.Entry entry : ((HashMap)mappings).entrySet()) {
                    double oldValue = Double.NaN;
                    double newValue = Double.NaN;
                    if (!((String)entry.getKey()).equals("?")) {
                        oldValue = Double.valueOf((String)entry.getKey());
                    }
                    if (!((String)entry.getValue()).equals("?")) {
                        newValue = Double.valueOf((String)entry.getValue());
                    }
                    numericalValueMapping.put(oldValue, newValue);
                }
                double numericalDefaultValue = Double.NaN;
                if (defaultMappingAdded && !defaultValue.equals("?")) {
                    numericalDefaultValue = Double.valueOf(defaultValue);
                }
                for (Map.Entry entry : attributeMap.entrySet()) {
                    Attribute oldAttribute = (Attribute)entry.getKey();
                    Attribute newAttribute = (Attribute)entry.getValue();
                    exampleSet.getExampleTable().addAttribute(newAttribute);
                    exampleSet.getAttributes().addRegular(newAttribute);
                    for (Example example : exampleSet) {
                        double value = example.getValue(oldAttribute);
                        Double mappedValue = (Double)numericalValueMapping.get(value);
                        if (mappedValue == null) {
                            if (defaultMappingAdded) {
                                example.setValue(newAttribute, numericalDefaultValue);
                            } else {
                                example.setValue(newAttribute, value);
                            }
                        } else {
                            example.setValue(newAttribute, mappedValue);
                        }
                        this.checkForStop();
                    }
                    exampleSet.getAttributes().remove(oldAttribute);
                    newAttribute.setName(oldAttribute.getName());
                }
            }
        }
        return exampleSet;
    }

    @Override
    protected int[] getFilterValueTypes() {
        return new int[]{0};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterType type = new ParameterTypeList(PARAMETER_VALUE_MAPPINGS, "The value mappings.", (ParameterType)new ParameterTypeString(PARAMETER_OLD_VALUES, "The original values which should be replaced.", false), (ParameterType)new ParameterTypeString(PARAMETER_NEW_VALUES, "Specifies the new value", false));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeString(PARAMETER_REPLACE_WHAT, "All occurrences of this value will be replaced.", true);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeString(PARAMETER_REPLACE_BY, "The new attribute value to use.", true);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_CONSIDER_REGULAR_EXPRESSIONS, "Enables matching based on regular expressions; original values may be specified as regular expressions.", false));
        type = new ParameterTypeBoolean(PARAMETER_ADD_DEFAULT_MAPPING, "If set to true, all original values which are not listed in the value mappings list are mapped to the default value.", false);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeString(PARAMETER_DEFAULT_VALUE, "The default value all original values are mapped to, if add_default_mapping is set to true.", true);
        type.setExpert(false);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_ADD_DEFAULT_MAPPING, true, true));
        types.add(type);
        return types;
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), AttributeValueMapper.class, null);
    }
}

