/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.AttributeSetPrecondition;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.HashSet;
import java.util.List;

public class AttributeMerge
extends AbstractDataProcessing {
    public static final String PARAMETER_FIRST_ATTRIBUTE = "first_attribute";
    public static final String PARAMETER_SECOND_ATTRIBUTE = "second_attribute";
    public static final String PARAMETER_SEPARATOR = "separator";
    public static final String PARAMETER_TRIM_VALUES = "trim_values";

    public AttributeMerge(OperatorDescription description) {
        super(description);
        this.getExampleSetInputPort().addPrecondition(new AttributeSetPrecondition(this.getExampleSetInputPort(), AttributeSetPrecondition.getAttributesByParameter(this, PARAMETER_FIRST_ATTRIBUTE, PARAMETER_SECOND_ATTRIBUTE), new String[0]));
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData metaData) {
        try {
            String attributeName1 = this.getParameterAsString(PARAMETER_FIRST_ATTRIBUTE);
            String attributeName2 = this.getParameterAsString(PARAMETER_SECOND_ATTRIBUTE);
            String separation = this.getParameterAsString(PARAMETER_SEPARATOR);
            AttributeMetaData amd = new AttributeMetaData(attributeName1 + separation + attributeName2, 1, null);
            amd.setValueSetRelation(SetRelation.UNKNOWN);
            metaData.addAttribute(amd);
            AttributeMetaData amd1 = metaData.getAttributeByName(attributeName1);
            AttributeMetaData amd2 = metaData.getAttributeByName(attributeName2);
            if (amd1 != null && amd2 != null && amd1.isNominal() && amd2.isNominal() && amd1.getValueSetRelation() == SetRelation.EQUAL && amd2.getValueSetRelation() == SetRelation.EQUAL) {
                HashSet<String> valueSet = new HashSet<String>();
                for (String value1 : amd1.getValueSet()) {
                    for (String value2 : amd2.getValueSet()) {
                        valueSet.add(value1 + separation + value2);
                    }
                }
                amd.setValueSet(valueSet, SetRelation.SUPERSET);
            }
            return metaData;
        }
        catch (UndefinedParameterError e) {
            return metaData;
        }
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        String firstAttributeName = this.getParameterAsString(PARAMETER_FIRST_ATTRIBUTE);
        String secondAttributeName = this.getParameterAsString(PARAMETER_SECOND_ATTRIBUTE);
        String separatorString = this.getParameterAsString(PARAMETER_SEPARATOR);
        boolean trimValues = this.getParameterAsBoolean(PARAMETER_TRIM_VALUES);
        Attribute firstAttribute = exampleSet.getAttributes().get(firstAttributeName);
        if (firstAttribute == null) {
            throw new UserError((Operator)this, 111, firstAttributeName);
        }
        Attribute secondAttribute = exampleSet.getAttributes().get(secondAttributeName);
        if (secondAttribute == null) {
            throw new UserError((Operator)this, 111, secondAttributeName);
        }
        Attribute mergedAttribute = AttributeFactory.createAttribute(firstAttribute.getName() + separatorString + secondAttribute.getName(), 1);
        exampleSet.getExampleTable().addAttribute(mergedAttribute);
        exampleSet.getAttributes().addRegular(mergedAttribute);
        for (Example example : exampleSet) {
            double firstValue = example.getValue(firstAttribute);
            double secondValue = example.getValue(secondAttribute);
            if (Double.isNaN(firstValue) || Double.isNaN(secondValue)) {
                example.setValue(mergedAttribute, Double.NaN);
                continue;
            }
            String firstValueString = example.getValueAsString(firstAttribute);
            String secondValueString = example.getValueAsString(secondAttribute);
            String mergedValueString = null;
            mergedValueString = trimValues ? firstValueString.trim() + separatorString.trim() + secondValueString.trim() : firstValueString + separatorString + secondValueString;
            double mergedValue = mergedAttribute.getMapping().mapString(mergedValueString);
            example.setValue(mergedAttribute, mergedValue);
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeAttribute(PARAMETER_FIRST_ATTRIBUTE, "The first attribute of this merger.", this.getExampleSetInputPort(), false));
        types.add(new ParameterTypeAttribute(PARAMETER_SECOND_ATTRIBUTE, "The second attribute of this merger.", this.getExampleSetInputPort(), false));
        types.add(new ParameterTypeString(PARAMETER_SEPARATOR, "Indicated a string which is used as separation of both values.", "_"));
        types.add(new ParameterTypeBoolean(PARAMETER_TRIM_VALUES, "Indicates if the two values should be trimmed, i.e. leading and trailing whitespaces should be removed, before the merge is performed.", false));
        return types;
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), AttributeMerge.class, null);
    }
}

