/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.AttributeSetPrecondition;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.List;

public class AttributeCopy
extends AbstractDataProcessing {
    public static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    public static final String PARAMETER_NEW_NAME = "new_name";

    public AttributeCopy(OperatorDescription description) {
        super(description);
        this.getExampleSetInputPort().addPrecondition(new AttributeSetPrecondition(this.getExampleSetInputPort(), AttributeSetPrecondition.getAttributesByParameter(this, PARAMETER_ATTRIBUTE_NAME), new String[0]));
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData metaData) throws UndefinedParameterError {
        AttributeMetaData attributeByName = metaData.getAttributeByName(this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME));
        if (attributeByName != null) {
            AttributeMetaData newAttribute = attributeByName.copy();
            newAttribute.setRole(null);
            if (this.isParameterSet(PARAMETER_NEW_NAME)) {
                newAttribute.setName(this.getParameterAsString(PARAMETER_NEW_NAME));
            } else {
                newAttribute.setName("copy(" + newAttribute.getName() + ")");
            }
            metaData.addAttribute(newAttribute);
        }
        return metaData;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        Attribute attribute = exampleSet.getAttributes().get(this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME));
        if (attribute == null) {
            throw new UserError((Operator)this, 111, this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME));
        }
        Attribute newAttribute = AttributeFactory.createAttribute(attribute);
        String newName = this.getParameterAsString(PARAMETER_NEW_NAME);
        if (newName != null) {
            newAttribute.setName(newName);
        } else {
            newAttribute.setName("copy(" + attribute.getName() + ")");
        }
        exampleSet.getExampleTable().addAttribute(newAttribute);
        exampleSet.getAttributes().addRegular(newAttribute);
        for (Example e : exampleSet) {
            e.setValue(newAttribute, e.getValue(attribute));
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeAttribute(PARAMETER_ATTRIBUTE_NAME, "The name of the nominal attribute to which values should be added.", this.getExampleSetInputPort(), false));
        types.add(new ParameterTypeString(PARAMETER_NEW_NAME, "The name of the new (copied) attribute. If this parameter is missing, simply the same name with an appended number is used.", true, false));
        return types;
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), AttributeCopy.class, null);
    }
}

