/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.BinominalAttribute;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.example.table.NominalMapping;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.AttributeSetPrecondition;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.List;

public class AddNominalValue
extends AbstractDataProcessing {
    public static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    public static final String PARAMETER_NEW_VALUE = "new_value";

    public AddNominalValue(OperatorDescription description) {
        super(description);
        this.getExampleSetInputPort().addPrecondition(new AttributeSetPrecondition(this.getExampleSetInputPort(), AttributeSetPrecondition.getAttributesByParameter(this, PARAMETER_ATTRIBUTE_NAME), 1, new String[0]));
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData metaData) throws UndefinedParameterError {
        AttributeMetaData targetAttribute = metaData.getAttributeByName(this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME));
        if (targetAttribute != null && this.getParameterAsString(PARAMETER_NEW_VALUE) != null) {
            targetAttribute.getValueSet().add(this.getParameterAsString(PARAMETER_NEW_VALUE));
            targetAttribute.setValueSetRelation(targetAttribute.getValueSetRelation().merge(SetRelation.SUBSET));
        }
        return metaData;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        Attribute attribute = exampleSet.getAttributes().get(this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME));
        if (attribute == null) {
            throw new UserError((Operator)this, 111, this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME));
        }
        if (!attribute.isNominal()) {
            throw new UserError((Operator)this, 119, attribute.getName(), this.getName());
        }
        String newValue = this.getParameterAsString(PARAMETER_NEW_VALUE);
        if (attribute instanceof BinominalAttribute) {
            Attribute newAttribute = AttributeFactory.createAttribute(1);
            ExampleTable table = exampleSet.getExampleTable();
            table.addAttribute(newAttribute);
            exampleSet.getAttributes().addRegular(newAttribute);
            NominalMapping originalMapping = attribute.getMapping();
            NominalMapping newMapping = newAttribute.getMapping();
            for (int i = 0; i < originalMapping.size(); ++i) {
                newMapping.mapString(originalMapping.mapIndex(i));
            }
            newAttribute.getMapping().mapString(newValue);
            for (Example example : exampleSet) {
                example.setValue(newAttribute, example.getValue(attribute));
            }
            exampleSet.getAttributes().remove(attribute);
            newAttribute.setName(attribute.getName());
        } else {
            attribute.getMapping().mapString(newValue);
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeAttribute(PARAMETER_ATTRIBUTE_NAME, "The name of the nominal attribute to which values should be added.", this.getExampleSetInputPort(), false, 1));
        types.add(new ParameterTypeString(PARAMETER_NEW_VALUE, "The value which should be added.", false));
        return types;
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), AddNominalValue.class, null);
    }
}

