/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.NonSpecialAttributesExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.MetaDataInfo;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class AbstractFilteredDataProcessing
extends AbstractDataProcessing {
    private final AttributeSubsetSelector attributeSelector = new AttributeSubsetSelector(this, this.getExampleSetInputPort(), this.getFilterValueTypes());

    public AbstractFilteredDataProcessing(OperatorDescription description) {
        super(description);
    }

    @Override
    protected final MetaData modifyMetaData(ExampleSetMetaData inputMetaData) {
        ExampleSetMetaData workingMetaData = inputMetaData.clone();
        ExampleSetMetaData subsetAmd = this.attributeSelector.getMetaDataSubset(workingMetaData, false);
        LinkedList<AttributeMetaData> unusedAttributes = new LinkedList<AttributeMetaData>();
        Iterator<AttributeMetaData> iterator = workingMetaData.getAllAttributes().iterator();
        while (iterator.hasNext()) {
            AttributeMetaData amd = iterator.next();
            if (subsetAmd.containsAttributeName(amd.getName()) != MetaDataInfo.YES) {
                unusedAttributes.add(amd);
                iterator.remove();
                continue;
            }
            if (!amd.isSpecial()) continue;
            amd.setRegular();
        }
        ExampleSetMetaData resultMetaData = workingMetaData;
        try {
            resultMetaData = this.applyOnFilteredMetaData(workingMetaData);
        }
        catch (UndefinedParameterError e) {
            // empty catch block
        }
        for (AttributeMetaData newMetaData : resultMetaData.getAllAttributes()) {
            AttributeMetaData oldMetaData = inputMetaData.getAttributeByName(newMetaData.getName());
            if (oldMetaData == null || !oldMetaData.isSpecial()) continue;
            String specialName = oldMetaData.getRole();
            newMetaData.setRole(specialName);
        }
        resultMetaData.addAllAttributes(unusedAttributes);
        return resultMetaData;
    }

    @Override
    public final ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        ExampleSet workingExampleSet = (ExampleSet)exampleSet.clone();
        Set<Attribute> selectedAttributes = this.attributeSelector.getAttributeSubset(workingExampleSet, false);
        LinkedList<Attribute> unusedAttributes = new LinkedList<Attribute>();
        Iterator<Attribute> iterator = workingExampleSet.getAttributes().allAttributes();
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            if (selectedAttributes.contains(attribute)) continue;
            unusedAttributes.add(attribute);
            iterator.remove();
        }
        workingExampleSet = new NonSpecialAttributesExampleSet(workingExampleSet);
        ExampleSet resultSet = this.applyOnFiltered(workingExampleSet);
        Iterator<AttributeRole> r = resultSet.getAttributes().allAttributeRoles();
        while (r.hasNext()) {
            AttributeRole newRole = r.next();
            AttributeRole oldRole = exampleSet.getAttributes().getRole(newRole.getAttribute().getName());
            if (oldRole == null || !oldRole.isSpecial()) continue;
            String specialName = oldRole.getSpecialName();
            newRole.setSpecial(specialName);
        }
        if (resultSet.size() != exampleSet.size()) {
            throw new UserError((Operator)this, 127, "changing the size of the example set is not allowed if the non-processed attributes should be kept.");
        }
        if (resultSet.getExampleTable().equals(exampleSet.getExampleTable())) {
            for (Attribute attribute : unusedAttributes) {
                AttributeRole role = exampleSet.getAttributes().getRole(attribute);
                resultSet.getAttributes().add(role);
            }
        } else {
            this.getLogger().warning("Underlying example table has changed: data copy into new table is necessary in order to keep non-processed attributes.");
            for (Attribute oldAttribute : unusedAttributes) {
                AttributeRole oldRole = exampleSet.getAttributes().getRole(oldAttribute);
                Attribute newAttribute = (Attribute)oldAttribute.clone();
                resultSet.getExampleTable().addAttribute(newAttribute);
                AttributeRole newRole = new AttributeRole(newAttribute);
                if (oldRole.isSpecial()) {
                    newRole.setSpecial(oldRole.getSpecialName());
                }
                resultSet.getAttributes().add(newRole);
                Iterator oldIterator = exampleSet.iterator();
                Iterator newIterator = resultSet.iterator();
                while (oldIterator.hasNext()) {
                    Example oldExample = (Example)oldIterator.next();
                    Example newExample = (Example)newIterator.next();
                    newExample.setValue(newAttribute, oldExample.getValue(oldAttribute));
                }
            }
        }
        return resultSet;
    }

    public abstract ExampleSet applyOnFiltered(ExampleSet var1) throws OperatorException;

    public abstract ExampleSetMetaData applyOnFilteredMetaData(ExampleSetMetaData var1) throws UndefinedParameterError;

    protected abstract int[] getFilterValueTypes();

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.addAll(this.attributeSelector.getParameterTypes());
        return types;
    }
}

