/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.preprocessing.AbstractValueProcessing;
import com.rapidminer.tools.math.container.Range;

public class AbsoluteValueFilter
extends AbstractValueProcessing {
    public AbsoluteValueFilter(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSetMetaData applyOnFilteredMetaData(ExampleSetMetaData metaData) {
        for (AttributeMetaData amd : metaData.getAllAttributes()) {
            if (!amd.isNumerical() || amd.isSpecial()) continue;
            Range range = amd.getValueRange();
            amd.setValueRange(new Range(0.0, Math.max(Math.abs(range.getLower()), Math.abs(range.getUpper()))), amd.getValueSetRelation());
            amd.getMean().setUnkown();
        }
        return metaData;
    }

    @Override
    public ExampleSet applyOnFiltered(ExampleSet exampleSet) throws OperatorException {
        for (Example example : exampleSet) {
            for (Attribute attribute : exampleSet.getAttributes()) {
                if (!attribute.isNumerical()) continue;
                double value = example.getValue(attribute);
                value = Math.abs(value);
                example.setValue(attribute, value);
            }
        }
        return exampleSet;
    }

    @Override
    protected int[] getFilterValueTypes() {
        return new int[]{2};
    }

    @Override
    public boolean writesIntoExistingData() {
        return true;
    }
}

