/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.discretization;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.preprocessing.PreprocessingModel;
import com.rapidminer.operator.preprocessing.discretization.AbstractDiscretizationOperator;
import com.rapidminer.operator.preprocessing.discretization.DiscretizationModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import com.rapidminer.tools.container.Tupel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class UserBasedDiscretization
extends AbstractDiscretizationOperator {
    public static final String PARAMETER_ATTRIBUTE_TYPE = "attribute_type";
    public static final String PARAMETER_UPPER_LIMIT = "upper_limit";
    public static final String PARAMETER_RANGE_NAMES = "classes";
    private static final String PARAMETER_CLASS_NAME = "class_names";
    public static final String[] attributeTypeStrings;
    public static final int ATTRIBUTE_TYPE_NOMINAL = 0;
    public static final int ATTRIBUTE_TYPE_ORDINAL = 1;

    public UserBasedDiscretization(OperatorDescription description) {
        super(description);
    }

    @Override
    protected Collection<AttributeMetaData> modifyAttributeMetaData(ExampleSetMetaData emd, AttributeMetaData amd) throws UndefinedParameterError {
        AttributeMetaData newAMD = new AttributeMetaData(amd.getName(), 1, amd.getRole());
        List<String[]> rangeList = this.getParameterList(PARAMETER_RANGE_NAMES);
        TreeSet<String> values = new TreeSet<String>();
        for (String[] pair : rangeList) {
            values.add(pair[0]);
        }
        newAMD.setValueSet(values, SetRelation.SUBSET);
        return Collections.singletonList(newAMD);
    }

    @Override
    public PreprocessingModel createPreprocessingModel(ExampleSet exampleSet) throws OperatorException {
        HashMap<String, SortedSet<Tupel<Double, String>>> ranges = new HashMap<String, SortedSet<Tupel<Double, String>>>();
        List<String[]> rangeList = this.getParameterList(PARAMETER_RANGE_NAMES);
        TreeSet<Tupel<Double, String>> thresholdPairs = new TreeSet<Tupel<Double, String>>();
        for (String[] pair : rangeList) {
            thresholdPairs.add(new Tupel<Double, String>(Double.valueOf(pair[1]), pair[0]));
        }
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!attribute.isNumerical()) continue;
            ranges.put(attribute.getName(), thresholdPairs);
        }
        DiscretizationModel model = new DiscretizationModel(exampleSet);
        model.setRanges(ranges);
        return model;
    }

    @Override
    public Class<? extends PreprocessingModel> getPreprocessingModelClass() {
        return DiscretizationModel.class;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterType type = new ParameterTypeCategory(PARAMETER_ATTRIBUTE_TYPE, "Attribute type of the discretized attribute.", attributeTypeStrings, 0);
        type.setExpert(false);
        types.add(type);
        ParameterTypeString classType = new ParameterTypeString(PARAMETER_CLASS_NAME, "The name of this range.");
        ParameterTypeDouble threshold = new ParameterTypeDouble(PARAMETER_UPPER_LIMIT, "The upper limit.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        LinkedList<String[]> defaultList = new LinkedList<String[]>();
        defaultList.add(new String[]{"first", "-Infinity"});
        defaultList.add(new String[]{"last", "Infinity"});
        type = new ParameterTypeList(PARAMETER_RANGE_NAMES, "Defines the classes and the upper limits of each class.", (ParameterType)classType, (ParameterType)threshold, defaultList);
        type.setExpert(false);
        types.add(type);
        return types;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), UserBasedDiscretization.class, this.attributeSelector);
    }

    static {
        UserBasedDiscretization.registerDiscretizationOperator(UserBasedDiscretization.class);
        attributeTypeStrings = new String[]{"nominal", "ordinal"};
    }
}

