/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.discretization;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.preprocessing.PreprocessingModel;
import com.rapidminer.operator.preprocessing.discretization.AbstractDiscretizationOperator;
import com.rapidminer.operator.preprocessing.discretization.DiscretizationModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.HashMap;
import java.util.List;

public class MinMaxBinDiscretization
extends AbstractDiscretizationOperator {
    public static final String PARAMETER_NUMBER_OF_BINS = "number_of_bins";
    public static final String PARAMETER_MIN_VALUE = "min_value";
    public static final String PARAMETER_MAX_VALUE = "max_value";
    public static final String PARAMETER_RANGE_NAME_TYPE = "range_name_type";
    public static final String PARAMETER_AUTOMATIC_NUMBER_OF_DIGITS = "automatic_number_of_digits";
    public static final String PARAMETER_NUMBER_OF_DIGITS = "number_of_digits";

    public MinMaxBinDiscretization(OperatorDescription description) {
        super(description);
    }

    @Override
    public PreprocessingModel createPreprocessingModel(ExampleSet exampleSet) throws OperatorException {
        DiscretizationModel model = new DiscretizationModel(exampleSet);
        exampleSet.recalculateAllAttributeStatistics();
        int numberOfBins = this.getParameterAsInt(PARAMETER_NUMBER_OF_BINS);
        HashMap<Attribute, double[]> ranges = new HashMap<Attribute, double[]>();
        double min = this.getParameterAsDouble(PARAMETER_MIN_VALUE);
        double max = this.getParameterAsDouble(PARAMETER_MAX_VALUE);
        if (min > max) {
            throw new UserError((Operator)this, 116, "min_value and max_value", "minimum must be less than maximum");
        }
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!attribute.isNumerical()) continue;
            double[] binRange = new double[numberOfBins + 2];
            binRange[0] = min;
            for (int b = 1; b < numberOfBins; ++b) {
                binRange[b] = min + (double)b / (double)numberOfBins * (max - min);
            }
            binRange[numberOfBins] = max;
            binRange[numberOfBins + 1] = Double.POSITIVE_INFINITY;
            ranges.put(attribute, binRange);
        }
        int numberOfDigits = -1;
        if (!this.getParameterAsBoolean(PARAMETER_AUTOMATIC_NUMBER_OF_DIGITS)) {
            numberOfDigits = this.getParameterAsInt(PARAMETER_NUMBER_OF_DIGITS);
        }
        model.setRanges(ranges, "range", this.getParameterAsInt(PARAMETER_RANGE_NAME_TYPE), numberOfDigits);
        return model;
    }

    @Override
    public Class<? extends PreprocessingModel> getPreprocessingModelClass() {
        return DiscretizationModel.class;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeInt(PARAMETER_NUMBER_OF_BINS, "Defines the number of bins which should be used for each attribute.", 2, Integer.MAX_VALUE, 2);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble(PARAMETER_MIN_VALUE, "The minimum value for the binning range.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, false));
        types.add(new ParameterTypeDouble(PARAMETER_MAX_VALUE, "The maximum value for the binning range.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, false));
        types.add(new ParameterTypeCategory(PARAMETER_RANGE_NAME_TYPE, "Indicates if long range names including the limits should be used.", DiscretizationModel.RANGE_NAME_TYPES, 0));
        type = new ParameterTypeBoolean(PARAMETER_AUTOMATIC_NUMBER_OF_DIGITS, "Indicates if the number of digits should be automatically determined for the range names.", true);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_RANGE_NAME_TYPE, DiscretizationModel.RANGE_NAME_TYPES, false, 2));
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_NUMBER_OF_DIGITS, "The minimum number of digits used for the interval names (-1: determine minimal number automatically).", -1, Integer.MAX_VALUE, -1);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_AUTOMATIC_NUMBER_OF_DIGITS, false, false));
        types.add(type);
        return types;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), MinMaxBinDiscretization.class, this.attributeSelector);
    }

    static {
        MinMaxBinDiscretization.registerDiscretizationOperator(MinMaxBinDiscretization.class);
    }
}

