/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.discretization;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SortedExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.preprocessing.PreprocessingModel;
import com.rapidminer.operator.preprocessing.discretization.AbstractDiscretizationOperator;
import com.rapidminer.operator.preprocessing.discretization.DiscretizationModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;

public class FrequencyDiscretization
extends AbstractDiscretizationOperator {
    public static final String PARAMETER_USE_SQRT_OF_EXAMPLES = "use_sqrt_of_examples";
    public static final String PARAMETER_NUMBER_OF_BINS = "number_of_bins";
    public static final String PARAMETER_RANGE_NAME_TYPE = "range_name_type";
    public static final String PARAMETER_AUTOMATIC_NUMBER_OF_DIGITS = "automatic_number_of_digits";
    public static final String PARAMETER_NUMBER_OF_DIGITS = "number_of_digits";

    public FrequencyDiscretization(OperatorDescription description) {
        super(description);
    }

    @Override
    protected Collection<AttributeMetaData> modifyAttributeMetaData(ExampleSetMetaData emd, AttributeMetaData amd) throws UndefinedParameterError {
        AttributeMetaData newAMD = new AttributeMetaData(amd.getName(), 1, amd.getRole());
        TreeSet<String> valueSet = new TreeSet<String>();
        if (this.getParameterAsInt(PARAMETER_RANGE_NAME_TYPE) == 1) {
            for (int i = 0; i < this.getParameterAsInt(PARAMETER_NUMBER_OF_BINS); ++i) {
                valueSet.add("range" + (i + 1));
            }
            newAMD.setValueSet(valueSet, SetRelation.EQUAL);
        } else {
            newAMD.setValueSet(valueSet, SetRelation.SUPERSET);
        }
        return Collections.singletonList(newAMD);
    }

    @Override
    public PreprocessingModel createPreprocessingModel(ExampleSet exampleSet) throws OperatorException {
        HashMap<Attribute, double[]> ranges = new HashMap<Attribute, double[]>();
        boolean useSqrt = this.getParameterAsBoolean(PARAMETER_USE_SQRT_OF_EXAMPLES);
        int numberOfBins = 0;
        if (!useSqrt) {
            numberOfBins = this.getParameterAsInt(PARAMETER_NUMBER_OF_BINS);
            if (numberOfBins >= exampleSet.size() - 1) {
                throw new UserError((Operator)this, 116, PARAMETER_NUMBER_OF_BINS, "number of bins must be smaller than number of examples (here: " + exampleSet.size() + ")");
            }
        } else {
            exampleSet.recalculateAllAttributeStatistics();
        }
        for (Attribute currentAttribute : exampleSet.getAttributes()) {
            double examplesPerBin;
            if (useSqrt) {
                numberOfBins = (int)Math.round(Math.sqrt(exampleSet.size() - (int)exampleSet.getStatistics(currentAttribute, "unknown")));
            }
            double[] attributeRanges = new double[numberOfBins];
            SortedExampleSet sortedSet = new SortedExampleSet(exampleSet, currentAttribute, 0);
            double currentBinSpace = examplesPerBin = (double)exampleSet.size() / (double)numberOfBins;
            double lastValue = Double.NaN;
            int currentBin = 0;
            for (Example example : sortedSet) {
                double value = example.getValue(currentAttribute);
                if (Double.isNaN(value)) continue;
                if (currentBinSpace < 1.0 && currentBin < numberOfBins && value != lastValue && !Double.isNaN(lastValue)) {
                    attributeRanges[currentBin] = (lastValue + value) / 2.0;
                    ++currentBin;
                    if ((currentBinSpace += examplesPerBin) < 1.0) {
                        throw new UserError((Operator)this, 944, currentAttribute.getName());
                    }
                }
                currentBinSpace -= 1.0;
                lastValue = value;
            }
            attributeRanges[numberOfBins - 1] = Double.POSITIVE_INFINITY;
            ranges.put(currentAttribute, attributeRanges);
        }
        DiscretizationModel model = new DiscretizationModel(exampleSet);
        int numberOfDigits = -1;
        if (!this.getParameterAsBoolean(PARAMETER_AUTOMATIC_NUMBER_OF_DIGITS)) {
            numberOfDigits = this.getParameterAsInt(PARAMETER_NUMBER_OF_DIGITS);
        }
        model.setRanges(ranges, "range", this.getParameterAsInt(PARAMETER_RANGE_NAME_TYPE), numberOfDigits);
        return model;
    }

    @Override
    public Class<? extends PreprocessingModel> getPreprocessingModelClass() {
        return DiscretizationModel.class;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_USE_SQRT_OF_EXAMPLES, "If true, the number of bins is instead determined by the square root of the number of non-missing values.", false));
        ParameterTypeSingle type = new ParameterTypeInt(PARAMETER_NUMBER_OF_BINS, "Defines the number of bins which should be used for each attribute.", 2, Integer.MAX_VALUE, 2);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_USE_SQRT_OF_EXAMPLES, false, false));
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeCategory(PARAMETER_RANGE_NAME_TYPE, "Indicates if long range names including the limits should be used.", DiscretizationModel.RANGE_NAME_TYPES, 0));
        type = new ParameterTypeBoolean(PARAMETER_AUTOMATIC_NUMBER_OF_DIGITS, "Indicates if the number of digits should be automatically determined for the range names.", true);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_RANGE_NAME_TYPE, DiscretizationModel.RANGE_NAME_TYPES, false, 2));
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_NUMBER_OF_DIGITS, "The minimum number of digits used for the interval names (-1: determine minimal number automatically).", -1, Integer.MAX_VALUE, -1);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_AUTOMATIC_NUMBER_OF_DIGITS, false, false));
        types.add(type);
        return types;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), FrequencyDiscretization.class, this.attributeSelector);
    }

    static {
        FrequencyDiscretization.registerDiscretizationOperator(FrequencyDiscretization.class);
    }
}

