/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.discretization;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.quickfix.OperatorInsertionQuickFix;
import com.rapidminer.operator.ports.quickfix.QuickFix;
import com.rapidminer.operator.preprocessing.PreprocessingOperator;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class AbstractDiscretizationOperator
extends PreprocessingOperator {
    private static Set<Class<? extends AbstractDiscretizationOperator>> ALL_DISCRETIZATION_OPERATORS = new HashSet<Class<? extends AbstractDiscretizationOperator>>();

    public AbstractDiscretizationOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    protected Collection<AttributeMetaData> modifyAttributeMetaData(ExampleSetMetaData emd, AttributeMetaData amd) throws UndefinedParameterError {
        AttributeMetaData newAMD = new AttributeMetaData(amd.getName(), 1, amd.getRole());
        return Collections.singletonList(newAMD);
    }

    protected static void registerDiscretizationOperator(Class<? extends AbstractDiscretizationOperator> clazz) {
        ALL_DISCRETIZATION_OPERATORS.add(clazz);
    }

    public static List<QuickFix> createDiscretizationFixes(InputPort inputPort, final String labelName) {
        LinkedList<QuickFix> fixes = new LinkedList<QuickFix>();
        for (final Class<? extends AbstractDiscretizationOperator> dclass : ALL_DISCRETIZATION_OPERATORS) {
            String name = dclass.getName();
            OperatorDescription[] ods = OperatorService.getOperatorDescriptions(dclass);
            if (ods.length > 0) {
                name = ods[0].getName();
            }
            fixes.add(new OperatorInsertionQuickFix("insert_discretization", new Object[]{name}, 10, inputPort){

                @Override
                public Operator createOperator() throws OperatorCreationException {
                    Object op = OperatorService.createOperator(dclass);
                    if (labelName != null) {
                        ((Operator)op).setParameter("attribute_filter_type", AttributeSubsetSelector.CONDITION_NAMES[3]);
                        ((Operator)op).setParameter("include_special_attributes", "true");
                        ((Operator)op).setParameter("regular_expression", labelName);
                    }
                    return op;
                }
            });
        }
        return fixes;
    }

    @Override
    public int[] getFilterValueTypes() {
        return new int[]{2};
    }
}

