/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.discretization;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SortedExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.preprocessing.PreprocessingModel;
import com.rapidminer.operator.preprocessing.discretization.AbstractDiscretizationOperator;
import com.rapidminer.operator.preprocessing.discretization.DiscretizationModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;

public class AbsoluteDiscretization
extends AbstractDiscretizationOperator {
    public static final String PARAMETER_SIZE_OF_BINS = "size_of_bins";
    public static final String PARAMETER_RANGE_NAME_TYPE = "range_name_type";
    public static final String PARAMETER_SORTING_DIRECTION = "sorting_direction";
    public static final String PARAMETER_AUTOMATIC_NUMBER_OF_DIGITS = "automatic_number_of_digits";
    public static final String PARAMETER_NUMBER_OF_DIGITS = "number_of_digits";

    public AbsoluteDiscretization(OperatorDescription description) {
        super(description);
    }

    @Override
    protected Collection<AttributeMetaData> modifyAttributeMetaData(ExampleSetMetaData emd, AttributeMetaData amd) throws UndefinedParameterError {
        AttributeMetaData newAMD = new AttributeMetaData(amd.getName(), 1, amd.getRole());
        TreeSet<String> valueSet = new TreeSet<String>();
        newAMD.setValueSet(valueSet, SetRelation.SUPERSET);
        if (this.getParameterAsInt(PARAMETER_RANGE_NAME_TYPE) == 1) {
            for (int i = 0; i < (int)Math.ceil((double)((Integer)emd.getNumberOfExamples().getNumber()).intValue() / (double)this.getParameterAsInt(PARAMETER_SIZE_OF_BINS)); ++i) {
                valueSet.add("range" + (i + 1));
            }
            switch (emd.getNumberOfExamples().getRelation()) {
                case AT_LEAST: {
                    newAMD.setValueSet(valueSet, SetRelation.SUPERSET);
                    break;
                }
                case AT_MOST: {
                    newAMD.setValueSet(valueSet, SetRelation.SUBSET);
                    break;
                }
                case EQUAL: {
                    newAMD.setValueSet(valueSet, SetRelation.EQUAL);
                    break;
                }
                case UNKNOWN: {
                    newAMD.setValueSet(valueSet, SetRelation.UNKNOWN);
                }
            }
        }
        return Collections.singletonList(newAMD);
    }

    @Override
    public PreprocessingModel createPreprocessingModel(ExampleSet exampleSet) throws OperatorException {
        DiscretizationModel model = new DiscretizationModel(exampleSet);
        exampleSet.recalculateAllAttributeStatistics();
        int sizeOfBins = this.getParameterAsInt(PARAMETER_SIZE_OF_BINS);
        int numberOfBins = exampleSet.size() / sizeOfBins;
        int numberOfExamples = exampleSet.size();
        if (numberOfBins * sizeOfBins < numberOfExamples) {
            ++numberOfBins;
        }
        HashMap<Attribute, double[]> ranges = new HashMap<Attribute, double[]>();
        int sortingDirection = this.getParameterAsInt(PARAMETER_SORTING_DIRECTION);
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!attribute.isNumerical()) continue;
            SortedExampleSet sortedSet = new SortedExampleSet(exampleSet, attribute, sortingDirection);
            double[] binRange = new double[numberOfBins];
            for (int i = 0; i < numberOfBins - 1; ++i) {
                int offset = (i + 1) * sizeOfBins - 1;
                double infimum = sortedSet.getExample(offset).getValue(attribute);
                double supremum = sortedSet.getExample(++offset).getValue(attribute);
                while (infimum == supremum && offset < numberOfExamples) {
                    supremum = sortedSet.getExample(offset).getValue(attribute);
                    ++offset;
                }
                if (sortingDirection == 1) {
                    binRange[numberOfBins - 2 - i] = (infimum + supremum) / 2.0;
                    continue;
                }
                binRange[i] = (infimum + supremum) / 2.0;
            }
            binRange[numberOfBins - 1] = Double.POSITIVE_INFINITY;
            ranges.put(attribute, binRange);
        }
        int numberOfDigits = -1;
        if (!this.getParameterAsBoolean(PARAMETER_AUTOMATIC_NUMBER_OF_DIGITS)) {
            numberOfDigits = this.getParameterAsInt(PARAMETER_NUMBER_OF_DIGITS);
        }
        model.setRanges(ranges, "range", this.getParameterAsInt(PARAMETER_RANGE_NAME_TYPE), numberOfDigits);
        return model;
    }

    @Override
    public Class<? extends PreprocessingModel> getPreprocessingModelClass() {
        return DiscretizationModel.class;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeInt(PARAMETER_SIZE_OF_BINS, "Defines the number of examples which should be used for each bin.", 1, Integer.MAX_VALUE, false);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeCategory(PARAMETER_SORTING_DIRECTION, "Indicates if the values should be sorted in increasing or decreasing order.", SortedExampleSet.SORTING_DIRECTIONS, 1));
        types.add(new ParameterTypeCategory(PARAMETER_RANGE_NAME_TYPE, "Indicates if long range names including the limits should be used.", DiscretizationModel.RANGE_NAME_TYPES, 0));
        type = new ParameterTypeBoolean(PARAMETER_AUTOMATIC_NUMBER_OF_DIGITS, "Indicates if the number of digits should be automatically determined for the range names.", true);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_RANGE_NAME_TYPE, DiscretizationModel.RANGE_NAME_TYPES, false, 2));
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_NUMBER_OF_DIGITS, "The minimum number of digits used for the interval names (-1: determine minimal number automatically).", -1, Integer.MAX_VALUE, -1);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_AUTOMATIC_NUMBER_OF_DIGITS, false, false));
        types.add(type);
        return types;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), AbsoluteDiscretization.class, this.attributeSelector);
    }

    static {
        AbsoluteDiscretization.registerDiscretizationOperator(AbsoluteDiscretization.class);
    }
}

