/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.NonSpecialAttributesExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.GenerateModelTransformationRule;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.operator.preprocessing.PreprocessingModel;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.container.Pair;
import java.util.Collection;
import java.util.List;

public abstract class PreprocessingOperator
extends AbstractDataProcessing {
    private final OutputPort modelOutput = (OutputPort)this.getOutputPorts().createPort("preprocessing model");
    protected final AttributeSubsetSelector attributeSelector = new AttributeSubsetSelector(this, this.getExampleSetInputPort(), this.getFilterValueTypes());
    public static final String PARAMETER_RETURN_PREPROCESSING_MODEL = "return_preprocessing_model";
    public static final String PARAMETER_CREATE_VIEW = "create_view";

    public PreprocessingOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule(new GenerateModelTransformationRule(this.getExampleSetInputPort(), this.modelOutput, this.getPreprocessingModelClass()));
        this.getExampleSetInputPort().addPrecondition(this.attributeSelector.makePrecondition());
    }

    @Override
    protected ExampleSetMetaData modifyMetaData(ExampleSetMetaData exampleSetMetaData) throws UndefinedParameterError {
        ExampleSetMetaData subsetMetaData = this.attributeSelector.getMetaDataSubset(exampleSetMetaData, this.isSupportingAttributeRoles());
        this.checkSelectedSubsetMetaData(subsetMetaData);
        for (AttributeMetaData amd : subsetMetaData.getAllAttributes()) {
            Collection<AttributeMetaData> replacement = null;
            replacement = this.modifyAttributeMetaData(exampleSetMetaData, amd);
            if (replacement == null) continue;
            if (replacement.size() == 1) {
                AttributeMetaData replacementAttribute = replacement.iterator().next();
                replacementAttribute.setRole(exampleSetMetaData.getAttributeByName(amd.getName()).getRole());
            }
            exampleSetMetaData.removeAttribute(amd);
            exampleSetMetaData.addAllAttributes(replacement);
        }
        return exampleSetMetaData;
    }

    protected void checkSelectedSubsetMetaData(ExampleSetMetaData subsetMetaData) {
    }

    protected abstract Collection<AttributeMetaData> modifyAttributeMetaData(ExampleSetMetaData var1, AttributeMetaData var2) throws UndefinedParameterError;

    public abstract PreprocessingModel createPreprocessingModel(ExampleSet var1) throws OperatorException;

    protected final ExampleSet getSelectedAttributes(ExampleSet exampleSet) throws UndefinedParameterError, UserError {
        return this.attributeSelector.getSubset(exampleSet, this.isSupportingAttributeRoles());
    }

    @Override
    public final ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        ExampleSet workingSet = this.isSupportingAttributeRoles() ? this.getSelectedAttributes(exampleSet) : new NonSpecialAttributesExampleSet(this.getSelectedAttributes(exampleSet));
        PreprocessingModel model = this.createPreprocessingModel(workingSet);
        model.setParameter(PARAMETER_CREATE_VIEW, this.getParameterAsBoolean(PARAMETER_CREATE_VIEW));
        if (this.getExampleSetOutputPort().isConnected()) {
            exampleSet = model.apply(exampleSet);
        }
        this.modelOutput.deliver(model);
        return exampleSet;
    }

    public ExampleSet doWork(ExampleSet exampleSet) throws OperatorException {
        ExampleSet workingSet = this.isSupportingAttributeRoles() ? this.getSelectedAttributes(exampleSet) : new NonSpecialAttributesExampleSet(this.getSelectedAttributes(exampleSet));
        PreprocessingModel model = this.createPreprocessingModel(workingSet);
        model.setParameter(PARAMETER_CREATE_VIEW, this.getParameterAsBoolean(PARAMETER_CREATE_VIEW));
        return model.apply(exampleSet);
    }

    public Pair<ExampleSet, Model> doWorkModel(ExampleSet exampleSet) throws OperatorException {
        exampleSet = this.apply(exampleSet);
        Model model = (Model)this.modelOutput.getData();
        return new Pair<ExampleSet, Model>(exampleSet, model);
    }

    @Override
    public boolean writesIntoExistingData() {
        return !this.getParameterAsBoolean(PARAMETER_CREATE_VIEW);
    }

    @Override
    public boolean shouldAutoConnect(OutputPort outputPort) {
        if (outputPort == this.modelOutput) {
            return this.getParameterAsBoolean(PARAMETER_RETURN_PREPROCESSING_MODEL);
        }
        return super.shouldAutoConnect(outputPort);
    }

    protected abstract int[] getFilterValueTypes();

    public abstract Class<? extends PreprocessingModel> getPreprocessingModelClass();

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeBoolean type = new ParameterTypeBoolean(PARAMETER_RETURN_PREPROCESSING_MODEL, "Indicates if the preprocessing model should also be returned", false);
        type.setHidden(true);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_CREATE_VIEW, "Create View to apply preprocessing instead of changing the data", false);
        type.setHidden(!this.isSupportingView());
        types.add(type);
        types.addAll(this.attributeSelector.getParameterTypes());
        return types;
    }

    public boolean isSupportingAttributeRoles() {
        return false;
    }

    public boolean isSupportingView() {
        return true;
    }
}

