/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.ModelViewExampleSet;
import com.rapidminer.example.set.NonSpecialAttributesExampleSet;
import com.rapidminer.example.set.RemappedExampleSet;
import com.rapidminer.operator.AbstractModel;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ViewModel;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.container.Pair;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class PreprocessingModel
extends AbstractModel
implements ViewModel {
    private static final long serialVersionUID = -2603663450216521777L;
    private HashMap<String, Object> parameterMap = new HashMap();

    protected PreprocessingModel(ExampleSet exampleSet) {
        super(exampleSet);
    }

    public abstract ExampleSet applyOnData(ExampleSet var1) throws OperatorException;

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        RemappedExampleSet nonSpecialRemapped = new RemappedExampleSet(this.isSupportingAttributeRoles() ? exampleSet : new NonSpecialAttributesExampleSet(exampleSet), this.getTrainingHeader(), false);
        LinkedList<AttributeRole> unusedList = new LinkedList<AttributeRole>();
        Iterator<AttributeRole> iterator = exampleSet.getAttributes().allAttributeRoles();
        while (iterator.hasNext()) {
            AttributeRole role = iterator.next();
            if (nonSpecialRemapped.getAttributes().get(role.getAttribute().getName()) != null) continue;
            unusedList.add(role);
        }
        boolean createView = false;
        if (this.parameterMap.containsKey("create_view")) {
            Boolean booleanObject = (Boolean)this.parameterMap.get("create_view");
            createView = false;
            if (booleanObject != null) {
                createView = booleanObject;
            }
        }
        ExampleSet result = createView ? new ModelViewExampleSet(nonSpecialRemapped, this) : this.applyOnData(nonSpecialRemapped);
        Iterator<Attribute> attributeIterator = result.getAttributes().allAttributes();
        LinkedList<Pair<Attribute, String>> roleList = new LinkedList<Pair<Attribute, String>>();
        Attributes inputAttributes = exampleSet.getAttributes();
        while (attributeIterator.hasNext()) {
            Attribute resultAttribute = attributeIterator.next();
            AttributeRole attributeRole = inputAttributes.getRole(resultAttribute.getName());
            if (attributeRole == null || !attributeRole.isSpecial()) continue;
            roleList.add(new Pair<Attribute, String>(resultAttribute, attributeRole.getSpecialName()));
        }
        for (Pair pair : roleList) {
            result.getAttributes().setSpecialAttribute((Attribute)pair.getFirst(), (String)pair.getSecond());
        }
        Attributes resultAttributes = result.getAttributes();
        for (AttributeRole role : unusedList) {
            resultAttributes.add(role);
        }
        return result;
    }

    @Override
    public String toResultString() {
        StringBuilder builder = new StringBuilder();
        Attributes trainAttributes = this.getTrainingHeader().getAttributes();
        builder.append("Model covering " + trainAttributes.size() + " attributes:" + Tools.getLineSeparator());
        for (Attribute attribute : trainAttributes) {
            builder.append(" - " + attribute.getName() + Tools.getLineSeparator());
        }
        return builder.toString();
    }

    @Override
    public void setParameter(String key, Object value) {
        this.parameterMap.put(key, value);
    }

    public boolean isSupportingAttributeRoles() {
        return false;
    }
}

