/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import com.rapidminer.tools.RandomGenerator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Obfuscator
extends AbstractDataProcessing {
    public static final String PARAMETER_OBFUSCATION_MAP_FILE = "obfuscation_map_file";

    public Obfuscator(OperatorDescription description) {
        super(description);
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData metaData) throws UndefinedParameterError {
        metaData.clear();
        metaData.attributesAreSuperset();
        return metaData;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        HashMap<String, String> obfuscatorMap = new HashMap<String, String>();
        RandomGenerator random = RandomGenerator.getRandomGenerator(this);
        Iterator<Attribute> i = exampleSet.getAttributes().allAttributes();
        while (i.hasNext()) {
            this.obfuscateAttribute(i.next(), obfuscatorMap, random);
        }
        File file = this.getParameterAsFile(PARAMETER_OBFUSCATION_MAP_FILE, true);
        if (file != null) {
            try {
                this.writeObfuscatorMap(obfuscatorMap, file);
            }
            catch (IOException e) {
                throw new UserError((Operator)this, 303, this.getParameterAsString(PARAMETER_OBFUSCATION_MAP_FILE), e.getMessage());
            }
        }
        return exampleSet;
    }

    private void obfuscateAttribute(Attribute attribute, Map<String, String> obfuscatorMap, RandomGenerator random) {
        String oldName = attribute.getName();
        String newName = random.nextString(8);
        attribute.setName(newName);
        attribute.setConstruction(newName);
        obfuscatorMap.put(newName, oldName);
        if (attribute.isNominal()) {
            for (String oldValue : attribute.getMapping().getValues()) {
                String newValue = random.nextString(8);
                Tools.replaceValue(attribute, oldValue, newValue);
                obfuscatorMap.put(oldName + ":" + newValue, oldValue);
            }
        }
    }

    private void writeObfuscatorMap(Map<String, String> obfuscatorMap, File file) throws IOException {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(file));
            for (Map.Entry<String, String> e : obfuscatorMap.entrySet()) {
                out.println(e.getKey() + "\t" + e.getValue());
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeFile type = new ParameterTypeFile(PARAMETER_OBFUSCATION_MAP_FILE, "File where the obfuscator map should be written to.", "obf", true);
        types.add(type);
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), Obfuscator.class, null);
    }
}

