/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.preprocessing.NoiseModel;
import com.rapidminer.operator.preprocessing.PreprocessingModel;
import com.rapidminer.operator.preprocessing.PreprocessingOperator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeNumber;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.container.Range;
import java.util.Collection;
import java.util.List;

public class NoiseOperator
extends PreprocessingOperator {
    public static final String PARAMETER_RANDOM_ATTRIBUTES = "random_attributes";
    public static final String PARAMETER_LABEL_NOISE = "label_noise";
    public static final String PARAMETER_DEFAULT_ATTRIBUTE_NOISE = "default_attribute_noise";
    public static final String PARAMETER_NOISE = "noise";
    public static final String PARAMETER_OFFSET = "offset";
    public static final String PARAMETER_LINEAR_FACTOR = "linear_factor";

    public NoiseOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public PreprocessingModel createPreprocessingModel(ExampleSet exampleSet) throws OperatorException {
        exampleSet.recalculateAllAttributeStatistics();
        String[] attributeNames = new String[this.getParameterAsInt(PARAMETER_RANDOM_ATTRIBUTES)];
        for (int i = 0; i < this.getParameterAsInt(PARAMETER_RANDOM_ATTRIBUTES); ++i) {
            attributeNames[i] = AttributeFactory.createName("random");
        }
        return new NoiseModel(exampleSet, RandomGenerator.getRandomGenerator(this), this.getParameterList(PARAMETER_NOISE), this.getParameterAsDouble(PARAMETER_DEFAULT_ATTRIBUTE_NOISE), this.getParameterAsDouble(PARAMETER_LABEL_NOISE), this.getParameterAsDouble(PARAMETER_OFFSET), this.getParameterAsDouble(PARAMETER_LINEAR_FACTOR), attributeNames);
    }

    @Override
    protected ExampleSetMetaData modifyMetaData(ExampleSetMetaData exampleSetMetaData) throws UndefinedParameterError {
        double defaultNoise;
        AttributeMetaData label = exampleSetMetaData.getLabelMetaData();
        if (label != null && label.isNumerical() && this.getParameterAsDouble(PARAMETER_LABEL_NOISE) > 0.0) {
            label.setValueSetRelation(SetRelation.SUPERSET);
        }
        if ((defaultNoise = this.getParameterAsDouble(PARAMETER_DEFAULT_ATTRIBUTE_NOISE)) > 0.0) {
            for (AttributeMetaData amd : exampleSetMetaData.getAllAttributes()) {
                if (amd.isSpecial() || !amd.isNumerical()) continue;
                amd.setValueSetRelation(SetRelation.SUPERSET);
            }
        }
        int numberOfRandomAttributes = this.getParameterAsInt(PARAMETER_RANDOM_ATTRIBUTES);
        for (int i = 0; i < numberOfRandomAttributes; ++i) {
            AttributeMetaData amd = new AttributeMetaData("random" + (i == 0 ? "" : i + ""), 4);
            amd.setValueRange(new Range(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY), SetRelation.SUBSET);
            exampleSetMetaData.addAttribute(amd);
        }
        return exampleSetMetaData;
    }

    @Override
    protected Collection<AttributeMetaData> modifyAttributeMetaData(ExampleSetMetaData emd, AttributeMetaData amd) {
        return null;
    }

    @Override
    public boolean isSupportingAttributeRoles() {
        return true;
    }

    @Override
    public boolean isSupportingView() {
        return false;
    }

    @Override
    public Class<? extends PreprocessingModel> getPreprocessingModelClass() {
        return NoiseModel.class;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeNumber type = new ParameterTypeInt(PARAMETER_RANDOM_ATTRIBUTES, "Adds this number of random attributes.", 0, Integer.MAX_VALUE, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_LABEL_NOISE, "Add this percentage of a numerical label range as a normal distributed noise or probability for a nominal label change.", 0.0, Double.POSITIVE_INFINITY, 0.05);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble(PARAMETER_DEFAULT_ATTRIBUTE_NOISE, "The standard deviation of the default attribute noise.", 0.0, Double.POSITIVE_INFINITY, 0.0));
        types.add(new ParameterTypeList(PARAMETER_NOISE, "List of noises for each attributes.", (ParameterType)new ParameterTypeAttribute("attribute", "To this attribute noise is added.", this.getExampleSetInputPort()), (ParameterType)new ParameterTypeDouble(PARAMETER_NOISE, "The strength of gaussian noise, which is added to this attribute.", 0.0, Double.POSITIVE_INFINITY, 0.05)));
        type = new ParameterTypeDouble(PARAMETER_OFFSET, "Offset added to the values of each random attribute", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_LINEAR_FACTOR, "Linear factor multiplicated with the values of each random attribute", 0.0, Double.POSITIVE_INFINITY, 1.0);
        types.add(type);
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }

    @Override
    protected int[] getFilterValueTypes() {
        return new int[]{0};
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), NoiseOperator.class, this.attributeSelector);
    }
}

