/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.SimpleAttributes;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.ViewAttribute;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.PreprocessingModel;
import com.rapidminer.tools.RandomGenerator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NoiseModel
extends PreprocessingModel {
    private static final long serialVersionUID = -1953073746280248791L;
    private double attributeNoise;
    private double labelNoise;
    private String[] noiseAttributeNames;
    private double noiseOffset;
    private double noiseFactor;
    private Attribute viewLabelParent;
    private Attribute viewLabel;
    private Set<Attribute> noiseAttributes = new HashSet<Attribute>();
    private RandomGenerator random;
    private Map<String, Double> noiseMap;
    private double labelRange;

    public NoiseModel(ExampleSet exampleSet, RandomGenerator localRandom, List<String[]> noises, double attributeNoise, double labelNoise, double noiseOffsett, double noiseFactor, String[] attributeNames) {
        super(exampleSet);
        this.attributeNoise = attributeNoise;
        this.labelNoise = labelNoise;
        this.noiseOffset = noiseOffsett;
        this.noiseFactor = noiseFactor;
        this.noiseAttributeNames = attributeNames;
        this.random = localRandom;
        this.noiseMap = new HashMap<String, Double>();
        for (String[] pair : noises) {
            this.noiseMap.put(pair[0], Double.valueOf(pair[1]));
        }
        Attribute label = exampleSet.getAttributes().getLabel();
        if (label != null) {
            exampleSet.recalculateAttributeStatistics(label);
            double min = exampleSet.getStatistics(label, "minimum");
            double max = exampleSet.getStatistics(label, "maximum");
            this.labelRange = Math.abs(max - min);
        }
    }

    @Override
    public ExampleSet applyOnData(ExampleSet exampleSet) throws OperatorException {
        Iterator reader = exampleSet.iterator();
        Attribute label = exampleSet.getAttributes().getLabel();
        while (reader.hasNext()) {
            Example example = (Example)reader.next();
            for (Attribute attribute : exampleSet.getAttributes()) {
                if (!attribute.isNumerical()) continue;
                Double noiseObject = this.noiseMap.get(attribute.getName());
                double noise = noiseObject == null ? this.attributeNoise : noiseObject;
                double noiseValue = this.random.nextGaussian() * noise;
                example.setValue(attribute, example.getValue(attribute) + noiseValue);
            }
            if (label == null) continue;
            if (label.isNumerical()) {
                double noiseValue = this.random.nextGaussian() * this.labelNoise * this.labelRange;
                example.setValue(label, example.getValue(label) + noiseValue);
                continue;
            }
            if (!label.isNominal() || label.getMapping().size() < 2 || !(this.random.nextDouble() < this.labelNoise)) continue;
            int oldValue = (int)example.getValue(label);
            int newValue = this.random.nextInt(label.getMapping().size() - 1);
            if (newValue >= oldValue) {
                ++newValue;
            }
            example.setValue(label, newValue);
        }
        LinkedList<Attribute> newAttributes = new LinkedList<Attribute>();
        for (String name : this.noiseAttributeNames) {
            Attribute newAttribute = AttributeFactory.createAttribute(name, 4);
            newAttributes.add(newAttribute);
            exampleSet.getExampleTable().addAttribute(newAttribute);
            exampleSet.getAttributes().addRegular(newAttribute);
        }
        for (Example example : exampleSet) {
            for (Attribute attribute : newAttributes) {
                example.setValue(attribute, this.noiseOffset + this.noiseFactor * this.random.nextGaussian());
            }
        }
        return exampleSet;
    }

    @Override
    public Attributes getTargetAttributes(ExampleSet parentSet) {
        SimpleAttributes attributes = new SimpleAttributes();
        Iterator<AttributeRole> specialRoles = parentSet.getAttributes().specialAttributes();
        while (specialRoles.hasNext()) {
            AttributeRole role = specialRoles.next();
            if (role.getSpecialName().equals("label") && this.labelNoise != 0.0) {
                AttributeRole clonedRole = (AttributeRole)role.clone();
                this.viewLabelParent = role.getAttribute();
                this.viewLabel = new ViewAttribute(this, this.viewLabelParent, this.viewLabelParent.getName(), this.viewLabelParent.getValueType(), this.viewLabelParent.isNominal() ? this.viewLabelParent.getMapping() : null);
                clonedRole.setAttribute(this.viewLabel);
                attributes.add(clonedRole);
                continue;
            }
            attributes.add(specialRoles.next());
        }
        Iterator<AttributeRole> i = parentSet.getAttributes().allAttributeRoles();
        while (i.hasNext()) {
            AttributeRole attributeRole = i.next();
            if (attributeRole.isSpecial()) continue;
            Attribute attribute = attributeRole.getAttribute();
            if (attribute.isNumerical()) {
                attributes.addRegular(new ViewAttribute(this, attribute, attribute.getName(), 4, null));
                continue;
            }
            attributes.add(attributeRole);
        }
        for (String name : this.noiseAttributeNames) {
            ViewAttribute viewAttribute = new ViewAttribute(this, null, name, 4, null);
            attributes.addRegular(viewAttribute);
            this.noiseAttributes.add(viewAttribute);
        }
        return attributes;
    }

    @Override
    public double getValue(Attribute targetAttribute, double value) {
        if (targetAttribute == this.viewLabel) {
            if (this.viewLabel.isNumerical()) {
                double min = this.getTrainingHeader().getStatistics(this.viewLabelParent, "minimum");
                double max = this.getTrainingHeader().getStatistics(this.viewLabelParent, "maximum");
                double labelRange = Math.abs(max - min);
                return value + this.random.nextGaussian() * this.labelNoise * labelRange;
            }
            if (this.viewLabel.isNominal() && this.viewLabel.getMapping().size() >= 2 && this.random.nextDouble() < this.labelNoise) {
                int oldValue;
                int newValue = oldValue = (int)value;
                while (newValue == oldValue) {
                    newValue = this.random.nextInt(this.viewLabel.getMapping().size());
                }
                return newValue;
            }
        } else {
            if (this.noiseAttributes.contains(targetAttribute)) {
                return this.noiseOffset + this.noiseFactor * this.random.nextGaussian();
            }
            Double noiseObject = this.noiseMap.get(targetAttribute.getName());
            double noise = noiseObject == null ? this.attributeNoise : noiseObject;
            double noiseValue = this.random.nextGaussian() * noise;
            return value + noiseValue;
        }
        return 0.0;
    }

    @Override
    public boolean isSupportingAttributeRoles() {
        return true;
    }
}

