/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class MaterializeDataInMemory
extends AbstractDataProcessing {
    public MaterializeDataInMemory(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        ExampleSet createdSet = MaterializeDataInMemory.materializeExampleSet(exampleSet, this.getParameterAsInt("datamanagement"));
        return createdSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeCategory("datamanagement", "Determines, how the data is represented internally.", DataRowFactory.TYPE_NAMES, 0, false));
        return types;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), MaterializeDataInMemory.class, null);
    }

    public static ExampleSet materializeExampleSet(ExampleSet exampleSet, int dataManagement) throws UndefinedParameterError {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        HashMap<Attribute, String> specialAttributes = new HashMap<Attribute, String>();
        Iterator<AttributeRole> a = exampleSet.getAttributes().allAttributeRoles();
        while (a.hasNext()) {
            AttributeRole role = a.next();
            Attribute attribute = role.getAttribute();
            Attribute newAttribute = AttributeFactory.createAttribute(attribute.getName(), attribute.getValueType());
            attributes.add(newAttribute);
            if (attribute.isNominal()) {
                newAttribute.setMapping(attribute.getMapping());
            }
            if (!role.isSpecial()) continue;
            specialAttributes.put(newAttribute, role.getSpecialName());
        }
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        DataRowFactory factory = new DataRowFactory(dataManagement, '.');
        for (Example example : exampleSet) {
            Iterator<Attribute> i = exampleSet.getAttributes().allAttributes();
            int attributeCounter = 0;
            DataRow row = factory.create(attributes.size());
            while (i.hasNext()) {
                Attribute attribute = i.next();
                double value = example.getValue(attribute);
                Attribute newAttribute = (Attribute)attributes.get(attributeCounter);
                if (attribute.isNominal() && !Double.isNaN(value)) {
                    String nominalValue = attribute.getMapping().mapIndex((int)value);
                    value = newAttribute.getMapping().mapString(nominalValue);
                }
                row.set(newAttribute, value);
                ++attributeCounter;
            }
            table.addDataRow(row);
        }
        ExampleSet createdSet = table.createExampleSet(specialAttributes);
        return createdSet;
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }
}

