/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import com.rapidminer.tools.metadata.MetaDataTools;
import java.util.List;
import java.util.TreeSet;

public class IdTagging
extends AbstractDataProcessing {
    public static final String PARAMETER_CREATE_NOMINAL_IDS = "create_nominal_ids";
    public static final String PARAMETER_OFFSET = "offset";

    public IdTagging(OperatorDescription description) {
        super(description);
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData metaData) {
        boolean nominalIds = this.getParameterAsBoolean(PARAMETER_CREATE_NOMINAL_IDS);
        if (nominalIds) {
            AttributeMetaData idAttribute = new AttributeMetaData("id", 1, "id");
            if (metaData.getNumberOfExamples().isKnown()) {
                TreeSet<String> values = new TreeSet<String>();
                int maxNumberOfNominals = AttributeMetaData.getMaximumNumberOfNominalValues();
                boolean incomplete = false;
                for (int i = 1; i <= (Integer)metaData.getNumberOfExamples().getValue(); ++i) {
                    values.add("id_" + i);
                    if (values.size() <= maxNumberOfNominals) continue;
                    incomplete = true;
                    break;
                }
                idAttribute.setValueSet(values, incomplete ? SetRelation.SUPERSET : SetRelation.EQUAL);
                if (incomplete) {
                    metaData.setNominalDataWasShrinked(true);
                }
            }
            metaData.addAttribute(idAttribute);
        } else {
            MetaDataTools.checkAndCreateIds(metaData);
        }
        return metaData;
    }

    @Override
    public ExampleSet apply(ExampleSet eSet) throws OperatorException {
        boolean nominalIds;
        Attribute idAttribute = eSet.getAttributes().getId();
        if (idAttribute != null) {
            this.getLogger().warning("Overwriting old id attribute!");
        }
        idAttribute = Tools.createSpecialAttribute(eSet, "id", (nominalIds = this.getParameterAsBoolean(PARAMETER_CREATE_NOMINAL_IDS)) ? 1 : 3);
        int offset = this.getParameterAsInt(PARAMETER_OFFSET);
        int currentId = 1 + offset;
        for (Example example : eSet) {
            example.setValue(idAttribute, nominalIds ? (double)idAttribute.getMapping().mapString("id_" + currentId) : (double)currentId);
            ++currentId;
            this.checkForStop();
        }
        return eSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeBoolean type = new ParameterTypeBoolean(PARAMETER_CREATE_NOMINAL_IDS, "True if nominal ids (instead of integer ids) should be created", false);
        type.setExpert(false);
        types.add(type);
        ParameterTypeInt offsetType = new ParameterTypeInt(PARAMETER_OFFSET, "The offset which will be added to each id", Integer.MIN_VALUE, Integer.MAX_VALUE, 0, true);
        types.add(offsetType);
        return types;
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), IdTagging.class, null);
    }
}

