/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import com.rapidminer.tools.Tools;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class GuessValueTypes
extends AbstractDataProcessing {
    public static final String PARAMETER_DECIMAL_POINT_CHARACTER = "decimal_point_character";
    public static final String PARAMETER_NUMBER_GROUPING_CHARACTER = "number_grouping_character";
    private AttributeSubsetSelector attributeSelector = new AttributeSubsetSelector(this, this.getExampleSetInputPort());

    public GuessValueTypes(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        char decimalPointCharacter = this.getParameterAsString(PARAMETER_DECIMAL_POINT_CHARACTER).charAt(0);
        Character groupingCharacter = null;
        if (this.isParameterSet(PARAMETER_NUMBER_GROUPING_CHARACTER)) {
            groupingCharacter = Character.valueOf(this.getParameterAsString(PARAMETER_NUMBER_GROUPING_CHARACTER).charAt(0));
        }
        Set<Attribute> attributeSet = this.attributeSelector.getAttributeSubset(exampleSet, false);
        int size = attributeSet.size();
        int[] valueTypes = new int[size];
        int index = 0;
        for (Attribute attribute : attributeSet) {
            valueTypes[index++] = attribute.getValueType();
        }
        boolean[] checked = new boolean[valueTypes.length];
        int checkedCounter = 0;
        for (Example example : exampleSet) {
            index = 0;
            for (Attribute attribute : attributeSet) {
                if (!attribute.isNominal() && !attribute.isNumerical()) continue;
                double originalValue = example.getValue(attribute);
                if (!Double.isNaN(originalValue) && !checked[index]) {
                    try {
                        String valueString = example.getValueAsString(attribute);
                        if (!"?".equals(valueString)) {
                            double value;
                            if (groupingCharacter != null) {
                                valueString = valueString.replace(groupingCharacter.toString(), "");
                            }
                            valueTypes[index] = Tools.isEqual(Math.round(value = Double.parseDouble(valueString = valueString.replace(decimalPointCharacter, '.'))), value) ? 3 : 4;
                        }
                    }
                    catch (NumberFormatException e) {
                        valueTypes[index] = 1;
                        checked[index] = true;
                        ++checkedCounter;
                    }
                }
                ++index;
            }
            if (checkedCounter < checked.length) continue;
            break;
        }
        LinkedList<AttributeRole> newAttributes = new LinkedList<AttributeRole>();
        index = 0;
        for (Attribute attribute : attributeSet) {
            if (!attribute.isNominal() && !attribute.isNumerical()) continue;
            AttributeRole role = exampleSet.getAttributes().getRole(attribute);
            Attribute newAttribute = AttributeFactory.createAttribute(valueTypes[index]);
            exampleSet.getExampleTable().addAttribute(newAttribute);
            AttributeRole newRole = new AttributeRole(newAttribute);
            newRole.setSpecial(role.getSpecialName());
            newAttributes.add(newRole);
            for (Example e : exampleSet) {
                double oldValue = e.getValue(attribute);
                if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(valueTypes[index], 2)) {
                    if (!Double.isNaN(oldValue)) {
                        String valueString = e.getValueAsString(attribute);
                        if ("?".equals(valueString)) {
                            e.setValue(newAttribute, Double.NaN);
                            continue;
                        }
                        if (groupingCharacter != null) {
                            valueString = valueString.replace(groupingCharacter.toString(), "");
                        }
                        valueString = valueString.replace(decimalPointCharacter, '.');
                        e.setValue(newAttribute, Double.parseDouble(valueString));
                        continue;
                    }
                    e.setValue(newAttribute, Double.NaN);
                    continue;
                }
                if (!Double.isNaN(oldValue)) {
                    String value = e.getValueAsString(attribute);
                    e.setValue(newAttribute, newAttribute.getMapping().mapString(value));
                    continue;
                }
                e.setValue(newAttribute, Double.NaN);
            }
            exampleSet.getExampleTable().removeAttribute(attribute);
            exampleSet.getAttributes().remove(role);
            newAttribute.setName(attribute.getName());
            ++index;
        }
        for (AttributeRole role : newAttributes) {
            if (role.isSpecial()) {
                exampleSet.getAttributes().setSpecialAttribute(role.getAttribute(), role.getSpecialName());
                continue;
            }
            exampleSet.getAttributes().addRegular(role.getAttribute());
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.addAll(this.attributeSelector.getParameterTypes());
        types.add(new ParameterTypeString(PARAMETER_DECIMAL_POINT_CHARACTER, "Character that is used as decimal point.", ".", false));
        types.add(new ParameterTypeString(PARAMETER_NUMBER_GROUPING_CHARACTER, "Character that is used as the number grouping character, i.e. for groups of thousands.", true));
        return types;
    }

    @Override
    public boolean writesIntoExistingData() {
        return true;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), GuessValueTypes.class, this.attributeSelector);
    }
}

