/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeSetPrecondition;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import java.util.List;

public class GroupByOperator
extends Operator {
    public static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    private InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set");
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");

    public GroupByOperator(OperatorDescription desc) {
        super(desc);
        this.exampleSetInput.addPrecondition(new AttributeSetPrecondition(this.exampleSetInput, AttributeSetPrecondition.getAttributesByParameter(this, PARAMETER_ATTRIBUTE_NAME), 1, new String[0]));
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        Attribute attribute = exampleSet.getAttributes().get(this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME));
        if (attribute == null) {
            throw new UserError((Operator)this, 111, this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME));
        }
        if (!attribute.isNominal()) {
            throw new UserError((Operator)this, 103, this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME), "grouping by attribute.");
        }
        SplittedExampleSet grouped = SplittedExampleSet.splitByAttribute(exampleSet, attribute);
        this.exampleSetOutput.deliver(grouped);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeAttribute(PARAMETER_ATTRIBUTE_NAME, "Name of the nominal attribute which is used to create partitions.", this.exampleSetInput, false, 1));
        return types;
    }
}

