/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.AbstractExampleSetProcessing;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.ArrayList;
import java.util.Iterator;

public class ExampleSetTranspose
extends AbstractExampleSetProcessing {
    public ExampleSetTranspose(OperatorDescription description) {
        super(description);
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData metaData) {
        return metaData.transpose();
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        int valueType = 4;
        Iterator<AttributeRole> a = exampleSet.getAttributes().allAttributeRoles();
        while (a.hasNext()) {
            AttributeRole attributeRole = a.next();
            if (attributeRole.isSpecial() && attributeRole.getSpecialName().equals("id") || !attributeRole.getAttribute().isNominal()) continue;
            valueType = 1;
            break;
        }
        ArrayList<Attribute> newAttributes = new ArrayList<Attribute>(exampleSet.size());
        Attribute newIdAttribute = AttributeFactory.createAttribute("id", 1);
        newAttributes.add(newIdAttribute);
        Attribute oldIdAttribute = exampleSet.getAttributes().getId();
        if (oldIdAttribute != null) {
            for (Example e : exampleSet) {
                double idValue = e.getValue(oldIdAttribute);
                String attributeName = "att_" + idValue;
                if (oldIdAttribute.isNominal()) {
                    attributeName = oldIdAttribute.getMapping().mapIndex((int)idValue);
                }
                newAttributes.add(AttributeFactory.createAttribute(attributeName, valueType));
            }
        } else {
            for (int i = 0; i < exampleSet.size(); ++i) {
                newAttributes.add(AttributeFactory.createAttribute("att_" + (i + 1), valueType));
            }
        }
        MemoryExampleTable table = new MemoryExampleTable(newAttributes);
        a = exampleSet.getAttributes().allAttributeRoles();
        while (a.hasNext()) {
            AttributeRole attributeRole = a.next();
            if (attributeRole.isSpecial() && attributeRole.getSpecialName().equals("id")) continue;
            Attribute attribute = attributeRole.getAttribute();
            double[] data = new double[exampleSet.size() + 1];
            data[0] = newIdAttribute.getMapping().mapString(attribute.getName());
            int counter = 1;
            for (Example e : exampleSet) {
                double currentValue;
                data[counter] = currentValue = e.getValue(attribute);
                Attribute newAttribute = (Attribute)newAttributes.get(counter);
                if (newAttribute.isNominal() && !Double.isNaN(currentValue)) {
                    String currentValueString = currentValue + "";
                    if (attribute.isNominal()) {
                        currentValueString = attribute.getMapping().mapIndex((int)currentValue);
                    }
                    data[counter] = newAttribute.getMapping().mapString(currentValueString);
                }
                ++counter;
            }
            table.addDataRow(new DoubleArrayDataRow(data));
        }
        ExampleSet result = table.createExampleSet(null, null, newIdAttribute);
        return result;
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), ExampleSetTranspose.class, null);
    }
}

