/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Deobfuscator
extends AbstractDataProcessing {
    public static final String PARAMETER_OBFUSCATION_MAP_FILE = "obfuscation_map_file";

    public Deobfuscator(OperatorDescription description) {
        super(description);
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData metaData) throws UndefinedParameterError {
        metaData.clear();
        metaData.attributesAreSuperset();
        return metaData;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        File file = this.getParameterAsFile(PARAMETER_OBFUSCATION_MAP_FILE);
        Map<String, String> obfuscatorMap = null;
        try {
            obfuscatorMap = this.readObfuscatorMap(file);
        }
        catch (IOException e) {
            throw new UserError((Operator)this, 302, this.getParameterAsString(PARAMETER_OBFUSCATION_MAP_FILE), e.getMessage());
        }
        Iterator<Attribute> i = exampleSet.getAttributes().allAttributes();
        while (i.hasNext()) {
            this.deObfuscateAttribute(i.next(), obfuscatorMap);
        }
        return exampleSet;
    }

    private void deObfuscateAttribute(Attribute attribute, Map<String, String> obfuscatorMap) {
        String obfuscatedName = attribute.getName();
        String newName = obfuscatorMap.get(obfuscatedName);
        if (newName != null) {
            attribute.setName(newName);
            attribute.setConstruction(newName);
        } else {
            this.logWarning("No name found in obfuscating map for attribute '" + obfuscatedName + "'.");
        }
        if (attribute.isNominal()) {
            for (String obfuscatedValue : attribute.getMapping().getValues()) {
                String newValue = obfuscatorMap.get(newName + ":" + obfuscatedValue);
                if (newValue != null) {
                    Tools.replaceValue(attribute, obfuscatedValue, newValue);
                    continue;
                }
                this.logWarning("No value found in obfuscating map for value '" + obfuscatedValue + "' of attribute '" + attribute.getName() + "'.");
            }
        }
    }

    private Map<String, String> readObfuscatorMap(File file) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = in.readLine()) != null) {
                String[] parts = line.trim().split("\\s");
                map.put(parts[0], parts[1]);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return map;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeFile type = new ParameterTypeFile(PARAMETER_OBFUSCATION_MAP_FILE, "File where the obfuscator map was written to.", "obf", false);
        type.setExpert(false);
        types.add(type);
        return types;
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getInputPort(), Deobfuscator.class, null);
    }
}

