/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.NonSpecialAttributesExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.AttributeSubsetPassThroughRule;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.MetaDataInfo;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class AttributeSubsetPreprocessing
extends OperatorChain {
    public static final String PARAMETER_DELIVER_INNER_RESULTS = "deliver_inner_results";
    public static final String PARAMETER_KEEP_SUBSET_ONLY = "keep_subset_only";
    private final InputPort exampleSetInput = this.getInputPorts().createPort("example set", ExampleSet.class);
    private final OutputPort innerExampleSetSource = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("exampleSet");
    private final InputPort innerExampleSetSink = this.getSubprocess(0).getInnerSinks().createPort("example set", ExampleSet.class);
    private final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private final PortPairExtender innerResultPorts = new PortPairExtender("through", this.getSubprocess(0).getInnerSinks(), this.getOutputPorts());
    private final AttributeSubsetSelector attributeSelector = new AttributeSubsetSelector(this, this.exampleSetInput);

    public AttributeSubsetPreprocessing(OperatorDescription description) {
        super(description, "Subset Process");
        this.getTransformer().addRule(new AttributeSubsetPassThroughRule(this.exampleSetInput, this.innerExampleSetSource, this, false));
        this.getTransformer().addRule(new SubprocessTransformRule(this.getSubprocess(0)));
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.innerExampleSetSink, this.exampleSetOutput, SetRelation.UNKNOWN){

            @Override
            public ExampleSetMetaData modifyExampleSet(ExampleSetMetaData inputMetaData) {
                if (AttributeSubsetPreprocessing.this.getParameterAsBoolean(AttributeSubsetPreprocessing.PARAMETER_KEEP_SUBSET_ONLY)) {
                    return inputMetaData;
                }
                MetaData metaData = AttributeSubsetPreprocessing.this.exampleSetInput.getMetaData();
                if (metaData instanceof ExampleSetMetaData) {
                    inputMetaData = (ExampleSetMetaData)metaData;
                    ExampleSetMetaData subsetAmd = AttributeSubsetPreprocessing.this.attributeSelector.getMetaDataSubset(inputMetaData, false);
                    LinkedList<AttributeMetaData> unusedAttributes = new LinkedList<AttributeMetaData>();
                    for (AttributeMetaData amd : inputMetaData.getAllAttributes()) {
                        if (subsetAmd.containsAttributeName(amd.getName()) == MetaDataInfo.YES) continue;
                        unusedAttributes.add(amd);
                    }
                    if (AttributeSubsetPreprocessing.this.innerExampleSetSink.getMetaData() instanceof ExampleSetMetaData) {
                        ExampleSetMetaData resultMetaData = (ExampleSetMetaData)AttributeSubsetPreprocessing.this.innerExampleSetSink.getMetaData().clone();
                        for (AttributeMetaData newMetaData : resultMetaData.getAllAttributes()) {
                            AttributeMetaData oldMetaData = inputMetaData.getAttributeByName(newMetaData.getName());
                            if (oldMetaData == null || !oldMetaData.isSpecial()) continue;
                            String specialName = oldMetaData.getRole();
                            newMetaData.setRole(specialName);
                        }
                        resultMetaData.addAllAttributes(unusedAttributes);
                        return resultMetaData;
                    }
                }
                return inputMetaData;
            }
        });
        this.getTransformer().addRule(this.innerResultPorts.makePassThroughRule());
        this.innerResultPorts.start();
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet inputSet = (ExampleSet)this.exampleSetInput.getData();
        ExampleSet workingExampleSet = (ExampleSet)inputSet.clone();
        Set<Attribute> selectedAttributes = this.attributeSelector.getAttributeSubset(workingExampleSet, false);
        LinkedList<Attribute> unusedAttributes = new LinkedList<Attribute>();
        Iterator<Attribute> iterator = workingExampleSet.getAttributes().allAttributes();
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            if (selectedAttributes.contains(attribute)) continue;
            unusedAttributes.add(attribute);
            iterator.remove();
        }
        workingExampleSet = new NonSpecialAttributesExampleSet(workingExampleSet);
        this.innerExampleSetSource.deliver(workingExampleSet);
        this.getSubprocess(0).execute();
        ExampleSet resultSet = (ExampleSet)this.innerExampleSetSink.getData();
        Iterator<AttributeRole> r = resultSet.getAttributes().allAttributeRoles();
        while (r.hasNext()) {
            AttributeRole newRole = r.next();
            AttributeRole oldRole = inputSet.getAttributes().getRole(newRole.getAttribute().getName());
            if (oldRole == null || !oldRole.isSpecial()) continue;
            String specialName = oldRole.getSpecialName();
            newRole.setSpecial(specialName);
        }
        if (!this.getParameterAsBoolean(PARAMETER_KEEP_SUBSET_ONLY)) {
            if (resultSet.size() != inputSet.size()) {
                throw new UserError((Operator)this, 127, "changing the size of the example set is not allowed if the non-processed attributes should be kept.");
            }
            if (resultSet.getExampleTable().equals(inputSet.getExampleTable())) {
                for (Attribute attribute : unusedAttributes) {
                    AttributeRole role = inputSet.getAttributes().getRole(attribute);
                    resultSet.getAttributes().add(role);
                }
            } else {
                this.logWarning("Underlying example table has changed: data copy into new table is necessary in order to keep non-processed attributes.");
                for (Attribute oldAttribute : unusedAttributes) {
                    AttributeRole oldRole = inputSet.getAttributes().getRole(oldAttribute);
                    Attribute newAttribute = (Attribute)oldAttribute.clone();
                    resultSet.getExampleTable().addAttribute(newAttribute);
                    AttributeRole newRole = new AttributeRole(newAttribute);
                    if (oldRole.isSpecial()) {
                        newRole.setSpecial(oldRole.getSpecialName());
                    }
                    resultSet.getAttributes().add(newRole);
                    Iterator oldIterator = inputSet.iterator();
                    Iterator newIterator = resultSet.iterator();
                    while (oldIterator.hasNext()) {
                        Example oldExample = (Example)oldIterator.next();
                        Example newExample = (Example)newIterator.next();
                        newExample.setValue(newAttribute, oldExample.getValue(oldAttribute));
                    }
                }
            }
        }
        this.innerResultPorts.passDataThrough();
        this.exampleSetOutput.deliver(resultSet);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.addAll(this.attributeSelector.getParameterTypes());
        types.add(new ParameterTypeBoolean(PARAMETER_KEEP_SUBSET_ONLY, "Indicates if the attributes which did not match the regular expression should be removed by this operator.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_DELIVER_INNER_RESULTS, "Indicates if the additional results (other than example set) of the inner operator should also be returned.", false));
        return types;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator((InputPort)this.getInputPorts().getPortByIndex(0), AttributeSubsetPreprocessing.class, this.attributeSelector);
    }
}

