/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.postprocessing;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.operator.postprocessing.Threshold;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.tools.math.ROCBias;
import com.rapidminer.tools.math.ROCData;
import com.rapidminer.tools.math.ROCDataGenerator;
import java.util.List;

public class ThresholdFinder
extends Operator {
    private static final String PARAMETER_MISCLASSIFICATION_COSTS_FIRST = "misclassification_costs_first";
    private static final String PARAMETER_MISCLASSIFICATION_COSTS_SECOND = "misclassification_costs_second";
    private static final String PARAMETER_SHOW_ROC_PLOT = "show_roc_plot";
    private static final String PARAMETER_USE_EXAMPLE_WEIGHTS = "use_example_weights";
    private InputPort exampleSetInput = this.getInputPorts().createPort("example set", ExampleSet.class);
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private OutputPort thresholdOutput = (OutputPort)this.getOutputPorts().createPort("threshold");

    public ThresholdFinder(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition(new ExampleSetPrecondition(this.exampleSetInput, 0, "label", "prediction", "confidence"));
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
        this.getTransformer().addGenerationRule(this.thresholdOutput, Threshold.class);
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        Attribute label = exampleSet.getAttributes().getLabel();
        exampleSet.recalculateAttributeStatistics(label);
        if (label == null) {
            throw new UserError((Operator)this, 105);
        }
        if (!label.isNominal()) {
            throw new UserError((Operator)this, 101, label, "threshold finding");
        }
        if (label.getMapping().size() != 2) {
            throw new UserError((Operator)this, 118, label, label.getMapping().getValues().size(), 2);
        }
        if (exampleSet.getAttributes().getPredictedLabel() == null) {
            throw new UserError((Operator)this, 107);
        }
        ROCDataGenerator rocDataGenerator = new ROCDataGenerator(this.getParameterAsDouble(PARAMETER_MISCLASSIFICATION_COSTS_SECOND), this.getParameterAsDouble(PARAMETER_MISCLASSIFICATION_COSTS_FIRST));
        ROCData rocData = rocDataGenerator.createROCData(exampleSet, this.getParameterAsBoolean(PARAMETER_USE_EXAMPLE_WEIGHTS), ROCBias.getROCBiasParameter(this));
        if (this.getParameterAsBoolean(PARAMETER_SHOW_ROC_PLOT)) {
            rocDataGenerator.createROCPlotDialog(rocData, true, true);
        }
        this.exampleSetOutput.deliver(exampleSet);
        this.thresholdOutput.deliver(new Threshold(rocDataGenerator.getBestThreshold(), label.getMapping().getNegativeString(), label.getMapping().getPositiveString()));
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> list = super.getParameterTypes();
        list.add(new ParameterTypeDouble(PARAMETER_MISCLASSIFICATION_COSTS_FIRST, "The costs assigned when an example of the first class is classified as one of the second.", 0.0, Double.POSITIVE_INFINITY, 1.0, false));
        list.add(new ParameterTypeDouble(PARAMETER_MISCLASSIFICATION_COSTS_SECOND, "The costs assigned when an example of the second class is classified as one of the first.", 0.0, Double.POSITIVE_INFINITY, 1.0, false));
        list.add(new ParameterTypeBoolean(PARAMETER_SHOW_ROC_PLOT, "Display a plot of the ROC curve.", false));
        list.add(new ParameterTypeBoolean(PARAMETER_USE_EXAMPLE_WEIGHTS, "Indicates if example weights should be used.", true));
        list.add(ROCBias.makeParameterType());
        return list;
    }
}

