/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.postprocessing;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeTypeException;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.operator.postprocessing.Threshold;

public class ThresholdApplier
extends Operator {
    private InputPort exampleSetInput = this.getInputPorts().createPort("example set", ExampleSet.class);
    private InputPort thresholdInput = this.getInputPorts().createPort("threshold", Threshold.class);
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");

    public ThresholdApplier(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition(new ExampleSetPrecondition(this.exampleSetInput, 0, "prediction", "confidence"));
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        Threshold threshold = (Threshold)this.thresholdInput.getData();
        Attribute predictedLabel = exampleSet.getAttributes().getPredictedLabel();
        if (predictedLabel == null) {
            throw new UserError((Operator)this, 107);
        }
        int zeroIndex = 0;
        int oneIndex = 0;
        try {
            zeroIndex = predictedLabel.getMapping().mapString(threshold.getZeroClass());
        }
        catch (AttributeTypeException e) {
            throw new UserError((Operator)this, 147, threshold.getZeroClass());
        }
        try {
            oneIndex = predictedLabel.getMapping().mapString(threshold.getOneClass());
        }
        catch (AttributeTypeException e) {
            throw new UserError((Operator)this, 147, threshold.getOneClass());
        }
        for (Example example : exampleSet) {
            double oneClassConfidence = example.getConfidence(threshold.getOneClass());
            double crispPrediction = oneClassConfidence > threshold.getThreshold() ? (double)oneIndex : (double)zeroIndex;
            example.setValue(predictedLabel, crispPrediction);
        }
        this.exampleSetOutput.deliver(exampleSet);
    }
}

