/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.postprocessing;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import java.util.HashMap;
import java.util.List;

public class SimpleUncertainPredictionsTransformation
extends AbstractDataProcessing {
    public static final String PARAMETER_CLASS_HANDLING = "class_handling";
    public static final String[] CLASS_HANDLING_MODES = new String[]{"balanced", "unbalanced"};
    public static final int CLASS_HANDLING_BALANCED = 0;
    public static final int CLASS_HANDLING_UNBALANCED = 1;
    public static final String PARAMETER_MIN_CONFIDENCE = "min_confidence";
    public static final String PARAMETER_MIN_CONFIDENCES = "min_confidences";
    public static final String PARAMETER_CLASS_VALUE = "class";

    public SimpleUncertainPredictionsTransformation(OperatorDescription description) {
        super(description);
        this.getExampleSetInputPort().addPrecondition(new ExampleSetPrecondition(this.getExampleSetInputPort(), 0, "prediction", "confidence"));
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        Attribute predictedLabel = exampleSet.getAttributes().getPredictedLabel();
        if (predictedLabel == null) {
            throw new UserError((Operator)this, 107);
        }
        if (!predictedLabel.isNominal()) {
            throw new UserError((Operator)this, 119, predictedLabel, this.getName());
        }
        switch (this.getParameterAsInt(PARAMETER_CLASS_HANDLING)) {
            case 0: {
                double minConfidence = this.getParameterAsDouble(PARAMETER_MIN_CONFIDENCE);
                for (Example example : exampleSet) {
                    double predictionValue = example.getValue(predictedLabel);
                    String predictionClass = predictedLabel.getMapping().mapIndex((int)predictionValue);
                    double confidence = example.getConfidence(predictionClass);
                    if (Double.isNaN(confidence) || !(confidence < minConfidence)) continue;
                    example.setValue(predictedLabel, Double.NaN);
                }
                break;
            }
            case 1: {
                HashMap<String, Double> thresholdMap = new HashMap<String, Double>();
                for (String[] threshold : this.getParameterList(PARAMETER_MIN_CONFIDENCES)) {
                    thresholdMap.put(threshold[0], Double.valueOf(threshold[1]));
                }
                for (Example example : exampleSet) {
                    double predictionValue = example.getValue(predictedLabel);
                    String predictionClass = predictedLabel.getMapping().mapIndex((int)predictionValue);
                    double confidence = example.getConfidence(predictionClass);
                    Double threshold = (Double)thresholdMap.get(predictionClass);
                    if (Double.isNaN(confidence) || threshold == null || !(confidence < threshold)) continue;
                    example.setValue(predictedLabel, Double.NaN);
                }
                break;
            }
        }
        return exampleSet;
    }

    @Override
    public boolean writesIntoExistingData() {
        return true;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> list = super.getParameterTypes();
        list.add(new ParameterTypeCategory(PARAMETER_CLASS_HANDLING, "The mode which defines if all classes are handled equally or if class individual thresholds are set.", CLASS_HANDLING_MODES, 0, false));
        ParameterType type = new ParameterTypeDouble(PARAMETER_MIN_CONFIDENCE, "The minimal confidence necessary for not setting the prediction to 'unknown'.", 0.0, 1.0, 0.5);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_CLASS_HANDLING, CLASS_HANDLING_MODES, true, 0));
        type.setExpert(false);
        list.add(type);
        type = new ParameterTypeList(PARAMETER_MIN_CONFIDENCES, "A list which defines individual thresholds for classes.", (ParameterType)new ParameterTypeString(PARAMETER_CLASS_VALUE, "The class for which the confidence threshold should be set."), (ParameterType)new ParameterTypeDouble(PARAMETER_MIN_CONFIDENCE, "The minimal confidence necessary for not setting the prediction to 'unknown'.", 0.0, 1.0, 0.5), false);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_CLASS_HANDLING, CLASS_HANDLING_MODES, true, 1));
        list.add(type);
        return list;
    }
}

