/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.postprocessing;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.postprocessing.PlattParameters;
import com.rapidminer.operator.postprocessing.PlattScaling;
import com.rapidminer.tools.Tools;
import java.util.Iterator;

public class PlattScalingModel
extends PredictionModel {
    private static final long serialVersionUID = 6281707312532843604L;
    private PlattParameters parameters;
    private Model model;

    public PlattScalingModel(ExampleSet exampleSet, Model model, PlattParameters parameters) {
        super(exampleSet);
        this.model = model;
        this.parameters = parameters;
    }

    @Override
    public ExampleSet performPrediction(ExampleSet exampleSet, Attribute predictedLabel) throws OperatorException {
        Attribute label = this.getLabel();
        int posLabel = label.getMapping().getPositiveIndex();
        int negLabel = label.getMapping().getNegativeIndex();
        String posLabelS = label.getMapping().mapIndex(posLabel);
        String negLabelS = label.getMapping().mapIndex(negLabel);
        exampleSet = this.model.apply(exampleSet);
        Iterator reader = exampleSet.iterator();
        while (reader.hasNext()) {
            double scaledNeg;
            Example example;
            double predicted = PlattScaling.getLogOddsPosConfidence((example = (Example)reader.next()).getConfidence(posLabelS));
            double scaledPos = 1.0 / (1.0 + Math.exp(predicted * this.parameters.getA() + this.parameters.getB()));
            example.setValue(predictedLabel, scaledPos >= (scaledNeg = 1.0 - scaledPos) ? (double)posLabel : (double)negLabel);
            example.setConfidence(posLabelS, scaledPos);
            example.setConfidence(negLabelS, scaledNeg);
        }
        return exampleSet;
    }

    @Override
    public String toString() {
        String result = super.toString() + " (" + this.parameters.toString() + ") " + Tools.getLineSeparator() + "Model: " + this.model.toResultString();
        return result;
    }
}

