/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.postprocessing;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.NominalMapping;
import com.rapidminer.operator.AbstractExampleSetProcessing;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.container.Tupel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class GeneratePredictionRankingOperator
extends AbstractExampleSetProcessing {
    public static final String PARAMETER_NUMBER_OF_RANKS = "number_of_ranks";
    public static final String PARAMETER_REMOVE_OLD_PREDICTIONS = "remove_old_predictions";

    public GeneratePredictionRankingOperator(OperatorDescription description) {
        super(description);
        this.getExampleSetInputPort().addPrecondition(new ExampleSetPrecondition(this.getExampleSetInputPort(), "prediction", 1));
        this.getExampleSetInputPort().addPrecondition(new ExampleSetPrecondition(this.getExampleSetInputPort(), "confidence", 2));
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        Attributes attributes = exampleSet.getAttributes();
        Attribute predictedLabel = attributes.getPredictedLabel();
        if (predictedLabel == null) {
            throw new UserError((Operator)this, 107);
        }
        NominalMapping mapping = predictedLabel.getMapping();
        int numberOfLabels = mapping.size();
        Attribute[] confidences = new Attribute[numberOfLabels];
        String[] labelValue = new String[numberOfLabels];
        int i = 0;
        Iterator<String> i$ = mapping.getValues().iterator();
        while (i$.hasNext()) {
            String value;
            labelValue[i] = value = i$.next();
            confidences[i] = attributes.getConfidence(value);
            if (confidences[i] == null) {
                throw new UserError((Operator)this, 154, value);
            }
            ++i;
        }
        int k = Math.min(numberOfLabels, this.getParameterAsInt(PARAMETER_NUMBER_OF_RANKS));
        Attribute[] kthPredictions = new Attribute[k];
        Attribute[] kthConfidences = new Attribute[k];
        for (i = 0; i < k; ++i) {
            kthPredictions[i] = AttributeFactory.createAttribute(predictedLabel.getValueType());
            kthPredictions[i].setName(predictedLabel.getName() + "_" + (i + 1));
            kthPredictions[i].setMapping((NominalMapping)predictedLabel.getMapping().clone());
            kthConfidences[i] = AttributeFactory.createAttribute(4);
            kthConfidences[i].setName("confidence_" + (i + 1));
            attributes.addRegular(kthPredictions[i]);
            attributes.addRegular(kthConfidences[i]);
            attributes.setSpecialAttribute(kthPredictions[i], "prediction_" + (i + 1));
            attributes.setSpecialAttribute(kthConfidences[i], "confidence_" + (i + 1));
        }
        exampleSet.getExampleTable().addAttributes(Arrays.asList(kthConfidences));
        exampleSet.getExampleTable().addAttributes(Arrays.asList(kthPredictions));
        for (Example example : exampleSet) {
            ArrayList<Tupel<Double, Integer>> labelConfidences = new ArrayList<Tupel<Double, Integer>>(numberOfLabels);
            for (i = 0; i < numberOfLabels; ++i) {
                labelConfidences.add(new Tupel<Double, Integer>(example.getValue(confidences[i]), i));
            }
            Collections.sort(labelConfidences);
            for (i = 0; i < k; ++i) {
                Tupel tupel = (Tupel)labelConfidences.get(numberOfLabels - i - 1);
                example.setValue(kthPredictions[i], ((Integer)tupel.getSecond()).intValue());
                example.setValue(kthConfidences[i], (Double)tupel.getFirst());
            }
        }
        attributes.remove(predictedLabel);
        if (this.getParameterAsBoolean(PARAMETER_REMOVE_OLD_PREDICTIONS)) {
            for (i = 0; i < confidences.length; ++i) {
                attributes.remove(confidences[i]);
            }
        }
        return exampleSet;
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_NUMBER_OF_RANKS, "This determines how many ranks will be considered. ", 2, Integer.MAX_VALUE, false));
        types.add(new ParameterTypeBoolean(PARAMETER_REMOVE_OLD_PREDICTIONS, "This indicates if the old confidence attributes should be removed.", true, false));
        return types;
    }
}

