/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.postprocessing;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.AbstractExampleSetProcessing;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.container.Tupel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GeneratePredictionOperator
extends AbstractExampleSetProcessing {
    public static final String PARAMETER_PREDICTION_NAME = "prediction_name";

    public GeneratePredictionOperator(OperatorDescription description) {
        super(description);
        this.getExampleSetInputPort().addPrecondition(new ExampleSetPrecondition(this.getExampleSetInputPort(), "confidence", 2));
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        HashMap<Attribute, String> confidenceAttributes = new HashMap<Attribute, String>();
        Iterator<AttributeRole> iterator = exampleSet.getAttributes().specialAttributes();
        while (iterator.hasNext()) {
            AttributeRole role = iterator.next();
            if (!role.getSpecialName().matches("confidence_.*")) continue;
            confidenceAttributes.put(role.getAttribute(), role.getSpecialName().replaceAll("^confidence_(.*)$", "$1"));
        }
        if (confidenceAttributes.size() > 0) {
            String predictionName = this.getParameterAsString(PARAMETER_PREDICTION_NAME);
            Attribute predictionAttribute = AttributeFactory.createAttribute("prediction(" + predictionName + ")", 1);
            for (String value : confidenceAttributes.values()) {
                predictionAttribute.getMapping().mapString(value);
            }
            exampleSet.getExampleTable().addAttribute(predictionAttribute);
            exampleSet.getAttributes().addRegular(predictionAttribute);
            exampleSet.getAttributes().setSpecialAttribute(predictionAttribute, "prediction");
            for (Example example : exampleSet) {
                ArrayList labelConfidences = new ArrayList(confidenceAttributes.size());
                for (Map.Entry entry : confidenceAttributes.entrySet()) {
                    labelConfidences.add(new Tupel(example.getValue((Attribute)entry.getKey()), entry.getValue()));
                }
                Collections.sort(labelConfidences);
                example.setValue(predictionAttribute, predictionAttribute.getMapping().mapString((String)((Tupel)labelConfidences.get(labelConfidences.size() - 1)).getSecond()));
            }
        }
        return exampleSet;
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_PREDICTION_NAME, "The name of the label that should be predicted.", false, false));
        return types;
    }
}

