/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.quickfix;

import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.quickfix.AbstractQuickFix;
import com.rapidminer.repository.RepositoryLocation;

public class RelativizeRepositoryLocationQuickfix
extends AbstractQuickFix {
    private String key;
    private Operator operator;

    public RelativizeRepositoryLocationQuickfix(Operator operator, String key, String value) {
        super(10, false, "relativize_repository_location", key, value);
        this.key = key;
        this.operator = operator;
    }

    @Override
    public void apply() {
        try {
            RepositoryLocation absLoc = this.operator.getParameterAsRepositoryLocation(this.key);
            RepositoryLocation processLoc = this.operator.getProcess().getRepositoryLocation().parent();
            if (processLoc == null) {
                SwingTools.showVerySimpleErrorMessage("quickfix_failed", "Process is not stored in repository.");
            } else {
                String relative = absLoc.makeRelative(processLoc);
                this.operator.setParameter(this.key, relative);
            }
        }
        catch (UserError e) {
            SwingTools.showVerySimpleErrorMessage("quickfix_failed", e.toString());
        }
    }
}

