/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.quickfix;

import com.rapidminer.gui.properties.AttributesPropertyDialog;
import com.rapidminer.gui.properties.ListPropertyDialog;
import com.rapidminer.gui.tools.dialogs.SetParameterDialog;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ports.quickfix.AbstractQuickFix;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttributes;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeConfiguration;
import com.rapidminer.parameter.ParameterTypeList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ParameterSettingQuickFix
extends AbstractQuickFix {
    private Operator operator;
    private String parameterName;
    private String value;

    public ParameterSettingQuickFix(Operator operator, String parameterName) {
        this(operator, parameterName, null, "set_parameter", parameterName.replace('_', ' '));
        ParameterType type = operator.getParameterType(parameterName);
        if (type instanceof ParameterTypeConfiguration) {
            this.seti18nKey("set_parameters_using_wizard", new Object[0]);
        } else if (type instanceof ParameterTypeList) {
            this.seti18nKey("set_parameter_list", parameterName);
        }
    }

    public ParameterSettingQuickFix(Operator operator, String parameterName, String value) {
        this(operator, parameterName, value, "correct_parameter_settings_by", parameterName, value);
        ParameterType type = operator.getParameterType(parameterName);
        if (type instanceof ParameterTypeConfiguration) {
            this.seti18nKey("correct_parameter_settings_with_wizard", new Object[0]);
        } else if (type instanceof ParameterTypeList) {
            this.seti18nKey("correct_parameter_settings_list", parameterName);
        }
        if (value != null && type instanceof ParameterTypeBoolean) {
            if (value.equals("true")) {
                this.seti18nKey("correct_parameter_settings_boolean_enable", parameterName);
            } else {
                this.seti18nKey("correct_parameter_settings_boolean_disable", parameterName);
            }
        }
    }

    public ParameterSettingQuickFix(Operator operator, String parameterName, String i18nKey, Object ... i18nArgs) {
        this(operator, parameterName, null, i18nKey, i18nArgs);
    }

    public ParameterSettingQuickFix(Operator operator, String parameterName, String value, String i18nKey, Object ... i18nArgs) {
        super(1, true, i18nKey, i18nArgs);
        this.operator = operator;
        this.parameterName = parameterName;
        this.value = value;
    }

    @Override
    public void apply() {
        ParameterType type = this.operator.getParameterType(this.parameterName);
        if (this.value != null) {
            this.operator.setParameter(this.parameterName, this.value);
        } else if (type instanceof ParameterTypeConfiguration) {
            ParameterTypeConfiguration confType = (ParameterTypeConfiguration)type;
            confType.getWizardCreator().createConfigurationWizard(type, confType.getWizardListener());
        } else if (type instanceof ParameterTypeList) {
            List<String[]> list = this.value != null ? ParameterTypeList.transformString2List(this.value) : new LinkedList<String[]>();
            ListPropertyDialog dialog = new ListPropertyDialog((ParameterTypeList)type, list, this.operator);
            dialog.setVisible(true);
            this.operator.setListParameter(this.parameterName, list);
        } else if (type instanceof ParameterTypeAttributes) {
            AttributesPropertyDialog dialog = new AttributesPropertyDialog((ParameterTypeAttributes)type, Collections.<String>emptyList());
            dialog.setVisible(true);
            if (dialog.isOk()) {
                boolean first = true;
                String attributeListString = "";
                Collection<String> attributeNames = dialog.getSelectedAttributeNames();
                for (String attributeName : attributeNames) {
                    if (!first) {
                        attributeListString = attributeListString.concat("|");
                    }
                    attributeListString = attributeListString.concat(attributeName);
                    first = false;
                }
                this.operator.setParameter(this.parameterName, attributeListString);
            }
        } else {
            SetParameterDialog dialog = new SetParameterDialog(this.operator, type);
            dialog.setVisible(true);
        }
    }
}

