/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.quickfix;

import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.quickfix.AbstractQuickFix;

public abstract class OperatorInsertionQuickFix
extends AbstractQuickFix {
    private final InputPort inputPort;
    private final int connectToPort;
    private final int connectFromPort;

    public OperatorInsertionQuickFix(String key, Object[] args, int rating, InputPort inputPort) {
        this(key, args, rating, inputPort, 0, 0);
    }

    public OperatorInsertionQuickFix(String key, Object[] args, int rating, InputPort inputPort, int connectToPort, int connectFromPort) {
        super(rating, false, key, args);
        this.inputPort = inputPort;
        this.connectToPort = connectToPort;
        this.connectFromPort = connectFromPort;
    }

    @Override
    public void apply() {
        try {
            Operator operator = this.createOperator();
            if (operator == null) {
                return;
            }
            ExecutionUnit process = this.inputPort.getPorts().getOwner().getOperator().getExecutionUnit();
            process.addOperator(operator);
            OutputPort source = this.inputPort.getSource();
            source.disconnect();
            source.connectTo((InputPort)operator.getInputPorts().getPortByIndex(this.connectToPort));
            ((OutputPort)operator.getOutputPorts().getPortByIndex(this.connectFromPort)).connectTo(this.inputPort);
        }
        catch (Exception e) {
            SwingTools.showSimpleErrorMessage("cannot_insert_operator", (Throwable)e, new Object[0]);
        }
    }

    public abstract Operator createOperator() throws OperatorCreationException;
}

