/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.quickfix;

import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.ports.quickfix.AbstractQuickFix;
import com.rapidminer.tools.math.similarity.nominal.LevenshteinDistance;
import java.util.Arrays;
import java.util.Collection;

public abstract class DictionaryQuickFix
extends AbstractQuickFix {
    private String description;
    private String[] options;
    private int nearestOption;

    public DictionaryQuickFix(String fixWhat, Collection<String> alternativeValues, String currentValue, String description) {
        super(1, true, "replace_by_dictionary", fixWhat);
        this.options = alternativeValues.toArray(new String[alternativeValues.size()]);
        this.description = description;
        Arrays.sort(this.options);
        int distance = Integer.MAX_VALUE;
        int i = 0;
        for (String string : this.options) {
            int currentDistance = LevenshteinDistance.getDistance(string, currentValue, 2);
            if (currentDistance < distance) {
                this.nearestOption = i;
                distance = currentDistance;
            }
            ++i;
        }
    }

    public DictionaryQuickFix(String arg, Collection<String> alternativeValues, String currentValue) {
        this(arg, alternativeValues, currentValue, "Select the appropriate value");
    }

    @Override
    public void apply() {
        Object option = SwingTools.showInputDialog("quickfix.replace_by_dictionary", this.options, (Object)this.options[this.nearestOption], this.description);
        if (option != null) {
            this.insertChosenOption(option.toString());
        }
    }

    public abstract void insertChosenOption(String var1);
}

