/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.quickfix;

import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.dialog.NewOperatorDialog;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.CompatibilityLevel;
import com.rapidminer.operator.ports.quickfix.AbstractQuickFix;

public class AddCompatibleOperatorQuickFix
extends AbstractQuickFix {
    private final InputPort inputPort;
    private final Class<? extends IOObject> neededClass;

    public AddCompatibleOperatorQuickFix(InputPort inputPort, Class<? extends IOObject> clazz) {
        super(9, false, "add_compatible", clazz.getSimpleName());
        this.inputPort = inputPort;
        this.neededClass = clazz;
    }

    @Override
    public void apply() {
        try {
            Operator oldOperator = this.inputPort.getPorts().getOwner().getOperator();
            Operator newOperator = NewOperatorDialog.selectMatchingOperator(RapidMinerGUI.getMainFrame().getActions(), null, this.neededClass, null, null);
            if (newOperator != null) {
                ExecutionUnit unit = this.inputPort.getPorts().getOwner().getConnectionContext();
                int index = unit.getIndexOfOperator(oldOperator);
                if (index == -1) {
                    unit.addOperator(newOperator);
                } else {
                    unit.addOperator(newOperator, unit.getIndexOfOperator(oldOperator));
                }
                if (RapidMinerGUI.getMainFrame().VALIDATE_AUTOMATICALLY_ACTION.isSelected()) {
                    unit.autoWireSingle(newOperator, CompatibilityLevel.VERSION_5, true, true);
                }
            }
        }
        catch (OperatorCreationException operatorCreationException) {
            // empty catch block
        }
    }
}

