/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.quickfix;

import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.ports.quickfix.QuickFix;
import com.rapidminer.tools.I18N;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;

public abstract class AbstractQuickFix
implements QuickFix {
    private Action action;
    private int rating;
    private boolean isInteractive;

    public AbstractQuickFix(int rating, boolean isInteractive, String i18nKey, Object ... i18nArgs) {
        this.isInteractive = isInteractive;
        this.rating = rating;
        this.seti18nKey(i18nKey, i18nArgs);
    }

    protected void seti18nKey(String i18nKey, Object ... i18nArgs) {
        this.action = new AbstractAction(I18N.getMessage(I18N.getErrorBundle(), "metadata.quickfix." + i18nKey, i18nArgs)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    AbstractQuickFix.this.apply();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, e.toString(), "Cannot apply quick fix", 0);
                    e.printStackTrace();
                }
            }
        };
        String iconName = I18N.getMessageOrNull(I18N.getGUIBundle(), "gui.action.quickfix." + i18nKey + ".icon", new Object[0]);
        if (iconName != null) {
            this.action.putValue("SmallIcon", SwingTools.createIcon("16/" + iconName));
        }
    }

    @Override
    public Action getAction() {
        return this.action;
    }

    @Override
    public int getRating() {
        return this.rating;
    }

    @Override
    public boolean isInteractive() {
        return this.isInteractive;
    }

    @Override
    public int compareTo(QuickFix arg0) {
        return arg0.getRating() - this.rating;
    }

    public String toString() {
        return (String)this.action.getValue("Name");
    }
}

