/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.metadata;

import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.AbstractPrecondition;
import com.rapidminer.operator.ports.metadata.CompatibilityLevel;
import com.rapidminer.operator.ports.metadata.InputMissingMetaDataError;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.MetaDataError;
import java.util.Collection;

public class SimplePrecondition
extends AbstractPrecondition {
    private final MetaData desiredMetaData;
    private final boolean mandatory;

    public SimplePrecondition(InputPort inputPort, MetaData desiredMetaData) {
        this(inputPort, desiredMetaData, true);
    }

    public SimplePrecondition(InputPort inputPort, MetaData desiredMetaData, boolean mandatory) {
        super(inputPort);
        this.desiredMetaData = desiredMetaData;
        this.mandatory = mandatory;
    }

    @Override
    public final void check(MetaData metaData) {
        InputPort inputPort = this.getInputPort();
        if (metaData == null) {
            if (this.isMandatory()) {
                inputPort.addError(new InputMissingMetaDataError(inputPort, this.desiredMetaData.getObjectClass(), null));
            }
        } else {
            if (this.desiredMetaData != null) {
                Collection<MetaDataError> errors = this.desiredMetaData.getErrorsForInput(inputPort, metaData, CompatibilityLevel.VERSION_5);
                for (MetaDataError error : errors) {
                    inputPort.addError(error);
                }
            }
            this.makeAdditionalChecks(metaData);
        }
    }

    @Override
    public String getDescription() {
        return (this.isMandatory() ? "<em>expects:</em> " : "<em>optional:</em> ") + this.desiredMetaData;
    }

    public void makeAdditionalChecks(MetaData received) {
    }

    @Override
    public boolean isCompatible(MetaData input, CompatibilityLevel level) {
        if (this.desiredMetaData != null) {
            return this.desiredMetaData.isCompatible(input, level);
        }
        return true;
    }

    @Override
    public void assumeSatisfied() {
        if (this.mandatory && this.desiredMetaData != null) {
            this.getInputPort().receiveMD(this.desiredMetaData.clone());
        }
    }

    protected boolean isMandatory() {
        return this.mandatory;
    }

    @Override
    public MetaData getExpectedMetaData() {
        return this.desiredMetaData;
    }
}

