/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.metadata;

import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDReal;
import com.rapidminer.operator.ports.metadata.ModelMetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.tools.math.container.Range;
import java.util.LinkedList;
import java.util.List;

public class PredictionModelMetaData
extends ModelMetaData {
    private static final long serialVersionUID = 1L;
    private AttributeMetaData predictedLabelMetaData;
    private List<AttributeMetaData> generatedPredictionAttributes = new LinkedList<AttributeMetaData>();

    protected PredictionModelMetaData() {
    }

    public PredictionModelMetaData(Class<? extends PredictionModel> modelClass) {
        this(modelClass, (ExampleSetMetaData)null);
    }

    public PredictionModelMetaData(Class<? extends PredictionModel> modelClass, ExampleSetMetaData trainingSetMetaData) {
        super(modelClass, trainingSetMetaData);
        AttributeMetaData labelAttributeMetaData;
        if (trainingSetMetaData != null && (labelAttributeMetaData = trainingSetMetaData.getLabelMetaData()) != null) {
            this.predictedLabelMetaData = labelAttributeMetaData.copy();
            this.predictedLabelMetaData.setRole("prediction");
            this.predictedLabelMetaData.setName("prediction(" + this.predictedLabelMetaData.getName() + ")");
            if (this.predictedLabelMetaData.isNumerical()) {
                this.predictedLabelMetaData.setValueSetRelation(SetRelation.SUPERSET);
            }
            this.predictedLabelMetaData.setMean(new MDReal());
            this.generatedPredictionAttributes.add(this.predictedLabelMetaData);
            if (this.predictedLabelMetaData.isNominal()) {
                if (this.predictedLabelMetaData.getValueSet().isEmpty()) {
                    AttributeMetaData confidence = new AttributeMetaData("confidence(?)", 4, "confidence_?");
                    confidence.setValueRange(new Range(0.0, 1.0), SetRelation.SUBSET);
                    this.generatedPredictionAttributes.add(confidence);
                    this.predictedLabelMetaData.setValueSetRelation(SetRelation.SUPERSET);
                } else {
                    for (String value : this.predictedLabelMetaData.getValueSet()) {
                        AttributeMetaData confidence = new AttributeMetaData("confidence(" + value + ")", 4, "confidence_" + value);
                        confidence.setValueRange(new Range(0.0, 1.0), SetRelation.SUBSET);
                        this.generatedPredictionAttributes.add(confidence);
                    }
                }
            }
        }
    }

    @Override
    public ExampleSetMetaData applyEffects(ExampleSetMetaData emd, InputPort inputPort) {
        if (this.predictedLabelMetaData == null) {
            return emd;
        }
        List<AttributeMetaData> predictionAttributes = this.getPredictionAttributeMetaData();
        if (predictionAttributes != null) {
            emd.addAllAttributes(predictionAttributes);
            emd.mergeSetRelation(this.getPredictionAttributeSetRelation());
        }
        return emd;
    }

    public List<AttributeMetaData> getPredictionAttributeMetaData() {
        return this.generatedPredictionAttributes;
    }

    public SetRelation getPredictionAttributeSetRelation() {
        if (this.predictedLabelMetaData != null) {
            return this.predictedLabelMetaData.getValueSetRelation();
        }
        return SetRelation.UNKNOWN;
    }

    @Override
    public String getDescription() {
        return super.getDescription() + "; generates: " + this.predictedLabelMetaData;
    }

    @Override
    public PredictionModelMetaData clone() {
        PredictionModelMetaData clone = (PredictionModelMetaData)super.clone();
        if (this.predictedLabelMetaData != null) {
            clone.predictedLabelMetaData = this.predictedLabelMetaData.clone();
        }
        if (this.generatedPredictionAttributes != null) {
            clone.generatedPredictionAttributes = new LinkedList<AttributeMetaData>(this.generatedPredictionAttributes);
        }
        return clone;
    }
}

