/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.metadata;

import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.InputMissingMetaDataError;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;

public class PassThroughRule
implements MDTransformationRule {
    private final OutputPort outputPort;
    private final InputPort inputPort;
    private final boolean optional;

    public PassThroughRule(InputPort inputPort, OutputPort outputPort, boolean mandatory) {
        this.outputPort = outputPort;
        this.inputPort = inputPort;
        this.optional = !mandatory;
    }

    @Override
    public void transformMD() {
        MetaData modified = this.inputPort.getMetaData();
        if (modified == null) {
            if (!this.optional) {
                this.inputPort.addError(new InputMissingMetaDataError(this.inputPort, null, null));
            }
            this.outputPort.deliverMD(null);
        } else {
            modified = modified.clone();
            modified.addToHistory(this.outputPort);
            this.outputPort.deliverMD(this.modifyMetaData(modified));
        }
    }

    public MetaData modifyMetaData(MetaData unmodifiedMetaData) {
        return unmodifiedMetaData;
    }

    public OutputPort getOutputPort() {
        return this.outputPort;
    }

    public InputPort getInputPort() {
        return this.inputPort;
    }

    public boolean isOptional() {
        return this.optional;
    }
}

