/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.metadata;

import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.PassThroughOrGenerateRuleCondition;
import java.util.Collection;
import java.util.LinkedList;

public class PassThroughOrGenerateRule
implements MDTransformationRule {
    private InputPort inputPort;
    private OutputPort outputPort;
    private MetaData generatedMetaData;
    private Collection<PassThroughOrGenerateRuleCondition> passThroughConditions = new LinkedList<PassThroughOrGenerateRuleCondition>();
    private Collection<PassThroughOrGenerateRuleCondition> generateConditions = new LinkedList<PassThroughOrGenerateRuleCondition>();

    public PassThroughOrGenerateRule(InputPort inputPort, OutputPort outputPort, MetaData generatedMetaData) {
        this.inputPort = inputPort;
        this.outputPort = outputPort;
        this.generatedMetaData = generatedMetaData;
    }

    @Override
    public void transformMD() {
        MetaData inputMD = this.inputPort.getMetaData();
        if (inputMD != null) {
            boolean ok = true;
            for (PassThroughOrGenerateRuleCondition condition : this.passThroughConditions) {
                if (condition.conditionFullfilled()) continue;
                condition.registerErrors();
                ok = false;
            }
            if (ok) {
                this.outputPort.deliverMD(this.transformPassedThrough(inputMD.clone()));
            }
        } else {
            boolean ok = true;
            for (PassThroughOrGenerateRuleCondition condition : this.generateConditions) {
                if (condition.conditionFullfilled()) continue;
                condition.registerErrors();
                ok = false;
            }
            if (ok) {
                this.outputPort.deliverMD(this.transformGenerated(this.generatedMetaData.clone()));
            }
        }
    }

    public MetaData transformGenerated(MetaData md) {
        md.addToHistory(this.outputPort);
        return md;
    }

    public MetaData transformPassedThrough(MetaData md) {
        md.addToHistory(this.outputPort);
        return md;
    }

    public void addPassThroughCondition(PassThroughOrGenerateRuleCondition condition) {
        this.passThroughConditions.add(condition);
    }

    public void addGenerateCondition(PassThroughOrGenerateRuleCondition condition) {
        this.generateConditions.add(condition);
    }
}

