/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.metadata;

import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.AbstractPrecondition;
import com.rapidminer.operator.ports.metadata.CompatibilityLevel;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.UndefinedParameterError;

public class ParameterConditionedPrecondition
extends AbstractPrecondition {
    private final Precondition condition;
    private final String parameterKey;
    private final String parameterValue;
    private final ParameterHandler handler;

    public ParameterConditionedPrecondition(InputPort inputPort, Precondition condition, ParameterHandler handler, String parameterKey, String parameterValue) {
        super(inputPort);
        this.condition = condition;
        this.parameterKey = parameterKey;
        this.parameterValue = parameterValue;
        this.handler = handler;
    }

    @Override
    public void assumeSatisfied() {
        this.condition.assumeSatisfied();
    }

    @Override
    public void check(MetaData metaData) {
        try {
            if (this.handler.getParameterAsString(this.parameterKey).equals(this.parameterValue)) {
                this.condition.check(metaData);
            }
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
    }

    @Override
    public String getDescription() {
        return this.condition.getDescription();
    }

    @Override
    public boolean isCompatible(MetaData input, CompatibilityLevel level) {
        return this.condition.isCompatible(input, level);
    }

    @Override
    public MetaData getExpectedMetaData() {
        return this.condition.getExpectedMetaData();
    }
}

