/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.metadata;

import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.PortOwner;
import com.rapidminer.operator.ports.metadata.MetaDataError;
import com.rapidminer.operator.ports.quickfix.DisconnectQuickFix;
import com.rapidminer.operator.ports.quickfix.QuickFix;
import java.util.Collections;
import java.util.List;

public class OperatorLoopError
implements MetaDataError {
    private OutputPort outputPort;
    private InputPort inputPort;
    private Port port;
    private final QuickFix fix;

    public OperatorLoopError(InputPort port) {
        this.port = port;
        this.inputPort = port;
        this.outputPort = port.getSource();
        this.fix = new DisconnectQuickFix(this.outputPort, this.inputPort);
    }

    public OperatorLoopError(OutputPort port) {
        this.port = port;
        this.outputPort = port;
        this.inputPort = port.getDestination();
        this.fix = new DisconnectQuickFix(this.outputPort, this.inputPort);
    }

    @Override
    public String getMessage() {
        return "This port is part of a loop.";
    }

    @Override
    public PortOwner getOwner() {
        return this.port.getPorts().getOwner();
    }

    @Override
    public Port getPort() {
        return this.port;
    }

    public List<QuickFix> getQuickFixes() {
        return Collections.singletonList(this.fix);
    }

    @Override
    public ProcessSetupError.Severity getSeverity() {
        return ProcessSetupError.Severity.ERROR;
    }
}

