/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.metadata;

import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.OutputPorts;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import java.util.Collection;

public class OneToManyPassThroughRule
implements MDTransformationRule {
    private final InputPort inputPort;
    private final Collection<OutputPort> outputPorts;

    public OneToManyPassThroughRule(InputPort inputPort, OutputPorts outputPorts) {
        this(inputPort, outputPorts.getAllPorts());
    }

    public OneToManyPassThroughRule(InputPort inputPort, Collection<OutputPort> outputPorts) {
        this.inputPort = inputPort;
        this.outputPorts = outputPorts;
    }

    @Override
    public void transformMD() {
        int i = 0;
        for (OutputPort outputPort : this.outputPorts) {
            MetaData metaData = this.inputPort.getMetaData();
            if (metaData != null) {
                metaData = metaData.clone();
                metaData.addToHistory(outputPort);
                outputPort.deliverMD(this.modifyMetaData(metaData, i));
            } else {
                outputPort.deliverMD(null);
            }
            ++i;
        }
    }

    public MetaData modifyMetaData(MetaData unmodifiedMetaData, int outputIndex) {
        return unmodifiedMetaData;
    }
}

