/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.metadata;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.renderer.RendererService;
import com.rapidminer.operator.Annotations;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.CompatibilityLevel;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.InputMissingMetaDataError;
import com.rapidminer.operator.ports.metadata.MetaDataError;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MetaData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient LinkedList<OutputPort> generationHistory = new LinkedList();
    private final Map<String, Object> keyValueMap = new HashMap<String, Object>();
    private Class<? extends IOObject> dataClass;
    private Annotations annotations = new Annotations();

    public MetaData() {
        this(IOObject.class);
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.generationHistory == null) {
            this.generationHistory = new LinkedList();
        }
        if (this.annotations == null) {
            this.annotations = new Annotations();
        }
        return this;
    }

    public MetaData(Class<? extends IOObject> dataClass) {
        this(dataClass, Collections.emptyMap());
    }

    public MetaData(Class<? extends IOObject> dataClass, String key, Object value) {
        this(dataClass, Collections.singletonMap(key, value));
    }

    public MetaData(Class<? extends IOObject> dataClass, Map<String, Object> keyValueMap) {
        this.dataClass = dataClass;
        this.keyValueMap.putAll(keyValueMap);
    }

    public void addToHistory(OutputPort generator) {
        this.generationHistory.addFirst(generator);
    }

    public List<OutputPort> getGenerationHistory() {
        return Collections.unmodifiableList(this.generationHistory);
    }

    public String getGenerationHistoryAsHTML() {
        boolean first = true;
        StringBuilder b = new StringBuilder();
        if (this.generationHistory != null) {
            for (OutputPort port : this.generationHistory) {
                if (!first) {
                    b.append(" &#8592; ");
                }
                b.append("<a href=\"rm://operator/");
                b.append(port.getPorts().getOwner().getOperator().getName());
                b.append("\">");
                b.append(port.getSpec());
                b.append("</a>");
                first = false;
            }
        }
        return b.toString();
    }

    public Class<? extends IOObject> getObjectClass() {
        return this.dataClass;
    }

    public Object getMetaData(String key) {
        return this.keyValueMap.get(key);
    }

    public Object putMetaData(String key, Object value) {
        return this.keyValueMap.put(key, value);
    }

    public MetaData clone() {
        MetaData clone;
        try {
            clone = (MetaData)this.getClass().newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot clone " + this, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot clone " + this, e);
        }
        clone.generationHistory = this.generationHistory == null ? new LinkedList() : new LinkedList<OutputPort>(this.generationHistory);
        clone.dataClass = this.getObjectClass();
        clone.keyValueMap.putAll(this.keyValueMap);
        if (this.annotations != null) {
            clone.annotations.putAll(this.annotations);
        }
        return clone;
    }

    public String toString() {
        return this.getObjectClass().getSimpleName() + (this.keyValueMap.isEmpty() ? "" : " hints: " + this.keyValueMap.toString());
    }

    public String getDescription() {
        String name = RendererService.getName(this.dataClass);
        if (name == null) {
            name = this.dataClass.getSimpleName();
        }
        StringBuilder desc = new StringBuilder(name);
        if (!this.keyValueMap.isEmpty()) {
            desc.append("; ");
            desc.append(this.keyValueMap);
        }
        if (this.annotations != null && !this.annotations.isEmpty()) {
            desc.append("<ul>");
            for (String key : this.annotations.getKeys()) {
                desc.append("<li><em>").append(key).append(":</em> ").append(this.annotations.get(key));
            }
            desc.append("</ul>");
        }
        return desc.toString();
    }

    public boolean isCompatible(MetaData isData, CompatibilityLevel level) {
        return this.getErrorsForInput(null, isData, level).isEmpty();
    }

    public Collection<MetaDataError> getErrorsForInput(InputPort inputPort, MetaData isData, CompatibilityLevel level) {
        if (!this.dataClass.isAssignableFrom(isData.dataClass)) {
            return Collections.singletonList(new InputMissingMetaDataError(inputPort, this.getObjectClass(), isData.getObjectClass()));
        }
        LinkedList<MetaDataError> errors = new LinkedList<MetaDataError>();
        if (level == CompatibilityLevel.VERSION_5) {
            for (Map.Entry<String, Object> entry : this.keyValueMap.entrySet()) {
                Object isValue = isData.keyValueMap.get(entry.getKey());
                if (entry.getValue().equals(isValue)) continue;
                errors.add(new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)inputPort, "general_property_mismatch", entry.getKey(), entry.getValue()));
            }
        }
        return errors;
    }

    public static MetaData forIOObject(IOObject ioo, boolean shortened) {
        MetaData result = ioo instanceof ExampleSet ? new ExampleSetMetaData((ExampleSet)ioo, shortened) : new MetaData(ioo.getClass());
        result.annotations = new Annotations(ioo.getAnnotations());
        return result;
    }

    public static MetaData forIOObject(IOObject ioo) {
        return MetaData.forIOObject(ioo, false);
    }

    public Annotations getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Annotations annotations) {
        this.annotations = annotations;
    }
}

