/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.metadata;

import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.InputPorts;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.OutputPorts;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;

public class ManyToManyPassThroughRule
implements MDTransformationRule {
    private InputPorts inputPorts;
    private OutputPorts outputPorts;

    public ManyToManyPassThroughRule(InputPorts inputPorts, OutputPorts outputPorts) {
        this.inputPorts = inputPorts;
        this.outputPorts = outputPorts;
    }

    @Override
    public void transformMD() {
        int numOut;
        assert (this.inputPorts.getNumberOfPorts() == this.outputPorts.getNumberOfPorts());
        int numIn = this.inputPorts.getNumberOfPorts();
        int num = numIn < (numOut = this.outputPorts.getNumberOfPorts()) ? numIn : numOut;
        for (int i = 0; i < num; ++i) {
            MetaData metaData = ((InputPort)this.inputPorts.getPortByIndex(i)).getMetaData();
            if (metaData != null) {
                metaData = metaData.clone();
                metaData.addToHistory((OutputPort)this.outputPorts.getPortByIndex(i));
                ((OutputPort)this.outputPorts.getPortByIndex(i)).deliverMD(this.modifyMetaData(metaData));
                continue;
            }
            ((OutputPort)this.outputPorts.getPortByIndex(i)).deliverMD(null);
        }
    }

    public MetaData modifyMetaData(MetaData unmodifiedMetaData) {
        return unmodifiedMetaData;
    }
}

